import KieSandboxFs from "@kie-tools/kie-sandbox-fs";
import { WorkspaceDescriptor } from "../worker/api/WorkspaceDescriptor";
import { WorkspaceFile } from "../context/WorkspacesContext";
import { LfsStorageService } from "./LfsStorageService";
import { CreateDescriptorArgs, LfsWorkspaceDescriptorService } from "./LfsWorkspaceDescriptorService";
interface BroadcastArgs {
    broadcast: boolean;
}
export declare class LfsWorkspaceService {
    private readonly args;
    private readonly WORKSPACES_BROADCAST_CHANNEL_NAME;
    constructor(args: {
        storageService: LfsStorageService;
        descriptorService: LfsWorkspaceDescriptorService;
        fsMountPoint: string;
        eventNamePrefix: string;
    });
    create(args: {
        storeFiles: (descriptor: WorkspaceDescriptor) => Promise<WorkspaceFile[]>;
        broadcastArgs: BroadcastArgs;
        descriptorArgs: CreateDescriptorArgs;
    }): Promise<{
        descriptor: WorkspaceDescriptor;
        files: WorkspaceFile[];
    }>;
    getFilesWithLazyContent(args: {
        fs: KieSandboxFs;
        workspaceId: string;
        globPattern?: string;
    }): Promise<WorkspaceFile[]>;
    delete(args: {
        workspaceId: string;
        broadcastArgs: BroadcastArgs;
    }): Promise<void>;
    rename(args: {
        workspaceId: string;
        newName: string;
        broadcastArgs: BroadcastArgs;
    }): Promise<void>;
    createOrOverwriteFile(args: {
        fs: KieSandboxFs;
        file: WorkspaceFile;
        broadcastArgs: BroadcastArgs;
    }): Promise<void>;
    getFile(args: {
        fs: KieSandboxFs;
        workspaceId: string;
        relativePath: string;
    }): Promise<WorkspaceFile | undefined>;
    updateFile(args: {
        fs: KieSandboxFs;
        file: WorkspaceFile;
        getNewContents: () => Promise<string>;
        broadcastArgs: BroadcastArgs;
    }): Promise<void>;
    deleteFile(args: {
        fs: KieSandboxFs;
        file: WorkspaceFile;
        broadcastArgs: BroadcastArgs;
    }): Promise<void>;
    renameFile(args: {
        fs: KieSandboxFs;
        file: WorkspaceFile;
        newFileNameWithoutExtension: string;
        broadcastArgs: BroadcastArgs;
    }): Promise<WorkspaceFile>;
    existsFile(args: {
        fs: KieSandboxFs;
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    private getAbsolutePath;
    private toWorkspaceFile;
    private toStorageFile;
}
export {};
//# sourceMappingURL=LfsWorkspaceService.d.ts.map