"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FsFlushManager = exports.FlushStateStatus = void 0;
var Subscribable_1 = require("./Subscribable");
var FlushStateStatus;
(function (FlushStateStatus) {
    FlushStateStatus[FlushStateStatus["FLUSH_IN_PROGRESS"] = 0] = "FLUSH_IN_PROGRESS";
    FlushStateStatus[FlushStateStatus["FLUSH_SCHEDULED"] = 1] = "FLUSH_SCHEDULED";
    FlushStateStatus[FlushStateStatus["FLUSH_PAUSED"] = 2] = "FLUSH_PAUSED";
})(FlushStateStatus = exports.FlushStateStatus || (exports.FlushStateStatus = {}));
var FsFlushManager = (function () {
    function FsFlushManager() {
        var _this = this;
        this.stateControl = new Map();
        this.subscribable = new Subscribable_1.Subscribable({
            newValueSupplier: function () { return __spreadArray([], __read(_this.stateControl.keys()), false); },
        });
    }
    FsFlushManager.prototype.pauseScheduledFlushIfScheduled = function (fsMountPoint) {
        var state = this.stateControl.get(fsMountPoint);
        if ((state === null || state === void 0 ? void 0 : state.status) === FlushStateStatus.FLUSH_SCHEDULED) {
            console.debug("Pausing scheduled flush for ".concat(fsMountPoint));
            clearTimeout(state.scheduledFlush);
            this.stateControl.set(fsMountPoint, { status: FlushStateStatus.FLUSH_PAUSED });
            this.subscribable._notifySubscribers();
        }
    };
    FsFlushManager.prototype.requestFsFlush = function (fsCache, fsMountPoint, debounceArgs) {
        return __awaiter(this, void 0, void 0, function () {
            var state;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        state = this.stateControl.get(fsMountPoint);
                        if (!!state) return [3, 1];
                        console.debug("Scheduling flush for ".concat(fsMountPoint));
                        this.scheduleFsFlush(fsCache, fsMountPoint, debounceArgs);
                        return [3, 7];
                    case 1:
                        if (!(state.status === FlushStateStatus.FLUSH_SCHEDULED)) return [3, 2];
                        console.debug("Debouncing flush request for ".concat(fsMountPoint));
                        clearTimeout(state.scheduledFlush);
                        this.scheduleFsFlush(fsCache, fsMountPoint, debounceArgs);
                        return [3, 7];
                    case 2:
                        if (!(state.status === FlushStateStatus.FLUSH_PAUSED)) return [3, 3];
                        console.debug("Resuming paused flush for ".concat(fsMountPoint));
                        this.scheduleFsFlush(fsCache, fsMountPoint, debounceArgs);
                        return [3, 7];
                    case 3:
                        if (!(state.status === FlushStateStatus.FLUSH_IN_PROGRESS)) return [3, 6];
                        console.debug("Flush requested while in progress for ".concat(fsMountPoint, ". Requesting another flush after completed."));
                        return [4, state.flushPromise];
                    case 4:
                        _a.sent();
                        console.debug("Flush requested right after one completed for ".concat(fsMountPoint, "."));
                        return [4, this.requestFsFlush(fsCache, fsMountPoint, debounceArgs)];
                    case 5:
                        _a.sent();
                        return [3, 7];
                    case 6: throw new Error("Oops! Impossible scenario for flushing '".concat(fsMountPoint, "'"));
                    case 7: return [2];
                }
            });
        });
    };
    FsFlushManager.prototype.executeFlush = function (fsCache, fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            var flush;
            var _this = this;
            return __generator(this, function (_a) {
                flush = fsCache.flushFs(fsMountPoint).then(function () {
                    console.debug("Flush complete for ".concat(fsMountPoint));
                    _this.stateControl.delete(fsMountPoint);
                    _this.subscribable._notifySubscribers();
                });
                this.stateControl.set(fsMountPoint, {
                    status: FlushStateStatus.FLUSH_IN_PROGRESS,
                    flushPromise: flush,
                });
                this.subscribable._notifySubscribers();
                return [2, flush];
            });
        });
    };
    FsFlushManager.prototype.scheduleFsFlush = function (fsCache, fsMountPoint, debounceArgs) {
        var _this = this;
        var flushScheduledTask = setTimeout(function () { return _this.executeFlush(fsCache, fsMountPoint); }, debounceArgs.debounceTimeoutInMs);
        this.stateControl.set(fsMountPoint, {
            status: FlushStateStatus.FLUSH_SCHEDULED,
            scheduledFlush: flushScheduledTask,
        });
        this.subscribable._notifySubscribers();
        return flushScheduledTask;
    };
    FsFlushManager.prototype.expediteFlush = function (fsCache, fsMountPoint, flushArgs) {
        return __awaiter(this, void 0, void 0, function () {
            var flushState;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        flushState = this.stateControl.get(fsMountPoint);
                        if (!!flushState) return [3, 3];
                        if (!flushArgs.executeEvenIfNotScheduled) return [3, 2];
                        return [4, this.executeFlush(fsCache, fsMountPoint)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [3, 12];
                    case 3:
                        if (!((flushState === null || flushState === void 0 ? void 0 : flushState.status) === FlushStateStatus.FLUSH_IN_PROGRESS)) return [3, 7];
                        return [4, flushState.flushPromise];
                    case 4:
                        _a.sent();
                        if (!flushArgs.executeEvenIfNotScheduled) return [3, 6];
                        return [4, this.executeFlush(fsCache, fsMountPoint)];
                    case 5:
                        _a.sent();
                        _a.label = 6;
                    case 6: return [3, 12];
                    case 7:
                        if (!((flushState === null || flushState === void 0 ? void 0 : flushState.status) === FlushStateStatus.FLUSH_SCHEDULED)) return [3, 9];
                        clearTimeout(flushState.scheduledFlush);
                        return [4, this.executeFlush(fsCache, fsMountPoint)];
                    case 8:
                        _a.sent();
                        return [3, 12];
                    case 9:
                        if (!((flushState === null || flushState === void 0 ? void 0 : flushState.status) === FlushStateStatus.FLUSH_PAUSED)) return [3, 11];
                        return [4, this.executeFlush(fsCache, fsMountPoint)];
                    case 10:
                        _a.sent();
                        return [3, 12];
                    case 11: throw new Error("Catastrophic error while expediting flush of ".concat(fsMountPoint, "."));
                    case 12: return [2];
                }
            });
        });
    };
    return FsFlushManager;
}());
exports.FsFlushManager = FsFlushManager;
//# sourceMappingURL=FsFlushManager.js.map