import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import _ from "lodash";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { BoxedFunctionKind, DmnBuiltInDataType, generateUuid } from "../../api";
import { PopoverMenu } from "../../contextMenu/PopoverMenu";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { FeelFunctionExpression } from "./FeelFunctionExpression";
import { FunctionKindSelector } from "./FunctionKindSelector";
import { JavaFunctionExpression } from "./JavaFunctionExpression";
import { ParametersPopover } from "./ParametersPopover";
import { PmmlFunctionExpression } from "./PmmlFunctionExpression";
import "./FunctionExpression.css";
export function FunctionExpression({ isNested, parentElementId, expression: boxedFunction, }) {
    switch (boxedFunction["@_kind"]) {
        case "Java":
            return (_jsx(JavaFunctionExpression, { functionExpression: boxedFunction, isNested: isNested, parentElementId: parentElementId }));
        case "PMML":
            return (_jsx(PmmlFunctionExpression, { functionExpression: boxedFunction, isNested: isNested, parentElementId: parentElementId }));
        case "FEEL":
        default:
            return (_jsx(FeelFunctionExpression, { functionExpression: boxedFunction, isNested: isNested, parentElementId: parentElementId }));
    }
}
export function useFunctionExpressionControllerCell(functionKind) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onFunctionKindSelect = useCallback((kind) => {
        setExpression((prev) => {
            if (kind === BoxedFunctionKind.Feel) {
                const retFeel = {
                    __$$element: "functionDefinition",
                    "@_label": prev["@_label"],
                    "@_id": generateUuid(),
                    "@_kind": BoxedFunctionKind.Feel,
                    "@_typeRef": undefined,
                    expression: {
                        __$$element: "literalExpression",
                        "@_id": generateUuid(),
                        "@_typeRef": undefined,
                    },
                    formalParameter: [],
                };
                return retFeel;
            }
            else if (kind === BoxedFunctionKind.Java) {
                const expressionId = generateUuid();
                const retJava = {
                    __$$element: "functionDefinition",
                    "@_label": prev["@_label"],
                    "@_id": expressionId,
                    expression: {
                        __$$element: "context",
                        "@_id": generateUuid(),
                    },
                    "@_kind": BoxedFunctionKind.Java,
                    "@_typeRef": undefined,
                    formalParameter: [],
                };
                return retJava;
            }
            else if (kind === BoxedFunctionKind.Pmml) {
                const retPmml = {
                    __$$element: "functionDefinition",
                    "@_label": prev["@_label"],
                    "@_id": generateUuid(),
                    expression: {
                        __$$element: "context",
                        "@_id": generateUuid(),
                    },
                    "@_kind": BoxedFunctionKind.Pmml,
                    "@_typeRef": undefined,
                    formalParameter: [],
                };
                return retPmml;
            }
            else {
                throw new Error("Shouldn't ever reach this point.");
            }
        });
    }, [setExpression]);
    return useMemo(() => _jsx(FunctionKindSelector, { selectedFunctionKind: functionKind, onFunctionKindSelect: onFunctionKindSelect }), [functionKind, onFunctionKindSelect]);
}
export function useFunctionExpressionParametersColumnHeader(formalParameters) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { editorRef } = useBoxedExpressionEditor();
    return useMemo(() => (_jsx(PopoverMenu, Object.assign({ appendTo: () => editorRef.current, className: "parameters-editor-popover", minWidth: "400px", body: _jsx(ParametersPopover, { parameters: formalParameters !== null && formalParameters !== void 0 ? formalParameters : [] }) }, { children: _jsx("div", Object.assign({ className: `parameters-list ${_.isEmpty(formalParameters) ? "empty-parameters" : ""}` }, { children: _jsx("p", Object.assign({ className: "pf-u-text-truncate" }, { children: _.isEmpty(formalParameters) ? (i18n.editParameters) : (_jsxs(_Fragment, { children: [_jsx("span", { children: "(" }), (formalParameters !== null && formalParameters !== void 0 ? formalParameters : []).map((parameter, i) => {
                            var _a;
                            return (_jsxs(React.Fragment, { children: [_jsx("span", { children: parameter["@_name"] }), _jsx("span", { children: ": " }), _jsxs("span", Object.assign({ className: "expression-info-data-type" }, { children: ["(", (_a = parameter["@_typeRef"]) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Undefined, ")"] })), i < (formalParameters !== null && formalParameters !== void 0 ? formalParameters : []).length - 1 && _jsx("span", { children: ", " })] }, i));
                        }), _jsx("span", { children: ")" })] })) })) })) }))), [formalParameters, i18n.editParameters, editorRef]);
}
//# sourceMappingURL=FunctionExpression.js.map