import { useCallback, useEffect, useMemo, useState } from "react";
import { useBeeTableResizableColumns, useBeeTableResizableColumnsDispatch } from "./BeeTableResizableColumnsContext";
import { apportionColumnWidths } from "./Hooks";
import { useNestedExpressionContainer } from "./NestedExpressionContainerContext";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH } from "./WidthConstants";
export function useFillingResizingWidth(columnIndex, column, reactTableInstance, shouldRenderRowIndexColumn) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    const minFillingWidth = useMemo(() => Math.max(nestedExpressionContainer.minWidth - (shouldRenderRowIndexColumn ? BEE_TABLE_ROW_INDEX_COLUMN_WIDTH : 0), sumColumnPropertyRecursively(column, "minWidth", nestedExpressionContainer.minWidth)), [column, nestedExpressionContainer.minWidth, shouldRenderRowIndexColumn]);
    const fillingWidth = useMemo(() => Math.max(nestedExpressionContainer.minWidth - (shouldRenderRowIndexColumn ? BEE_TABLE_ROW_INDEX_COLUMN_WIDTH : 0), sumColumnPropertyRecursively(column, "width", nestedExpressionContainer.actualWidth)), [column, nestedExpressionContainer.actualWidth, nestedExpressionContainer.minWidth, shouldRenderRowIndexColumn]);
    const [fillingResizingWidth, setFillingResizingWidth] = useState({
        isPivoting: false,
        value: 0,
    });
    const { columnResizingWidths } = useBeeTableResizableColumns();
    const { updateColumnResizingWidths } = useBeeTableResizableColumnsDispatch();
    const totalColumnResizingWidth = useMemo(() => {
        return getTotalColumnResizingWidth(column, columnResizingWidths, reactTableInstance);
    }, [column, columnResizingWidths, reactTableInstance]);
    useEffect(() => {
        setFillingResizingWidth((prev) => {
            if (prev.isPivoting) {
                return prev;
            }
            else if (prev.value === totalColumnResizingWidth.value) {
                return prev;
            }
            else if (isFlexbileColumn(column)) {
                return { isPivoting: false, value: totalColumnResizingWidth.value };
            }
            else if (isParentColumn(column)) {
                return { isPivoting: false, value: totalColumnResizingWidth.value };
            }
            else {
                return prev;
            }
        });
    }, [column, totalColumnResizingWidth]);
    const setFillingWidth = useCallback((newWidth) => {
        if (isFlexbileColumn(column)) {
            updateColumnResizingWidths(new Map([[columnIndex, { isPivoting: false, value: newWidth }]]));
        }
        if (isParentColumn(column)) {
            const newColumnResizingWidths = computeNewSubColumnResizingWidths({
                isPivoting: false,
                newTotalWidth: newWidth,
                reactTableInstance,
                column,
            });
            updateColumnResizingWidths(newColumnResizingWidths);
        }
    }, [column, columnIndex, reactTableInstance, updateColumnResizingWidths]);
    useEffect(() => {
        if (fillingResizingWidth.isPivoting) {
            return;
        }
        if (isFlexbileColumn(column)) {
            updateColumnResizingWidths(new Map([
                [
                    columnIndex,
                    {
                        isPivoting: totalColumnResizingWidth.isPivoting,
                        value: nestedExpressionContainer.resizingWidth.value,
                    },
                ],
            ]));
        }
    }, [
        column,
        columnIndex,
        fillingResizingWidth.isPivoting,
        nestedExpressionContainer.resizingWidth.value,
        totalColumnResizingWidth.isPivoting,
        updateColumnResizingWidths,
    ]);
    useEffect(() => {
        if (!fillingResizingWidth.isPivoting) {
            return;
        }
        if (isFlexbileColumn(column)) {
            updateColumnResizingWidths(new Map([[columnIndex, fillingResizingWidth]]));
            return;
        }
        if (isParentColumn(column)) {
            const newColumnResizingWidths = computeNewSubColumnResizingWidths({
                isPivoting: true,
                newTotalWidth: fillingResizingWidth.value,
                reactTableInstance,
                column,
            });
            updateColumnResizingWidths(newColumnResizingWidths);
        }
    }, [column, columnIndex, fillingResizingWidth, reactTableInstance, updateColumnResizingWidths]);
    return { fillingResizingWidth, setFillingResizingWidth, minFillingWidth, fillingWidth, setFillingWidth };
}
export function sumColumnPropertyRecursively(column, property, containerValue) {
    var _a, _b, _c, _d;
    if (isFlexbileColumn(column)) {
        return (_a = containerValue !== null && containerValue !== void 0 ? containerValue : column.minWidth) !== null && _a !== void 0 ? _a : 0;
    }
    if (isParentColumn(column)) {
        return ((_b = column.columns) !== null && _b !== void 0 ? _b : []).reduce((acc, c) => acc + sumColumnPropertyRecursively(c, property, containerValue), 0);
    }
    return (_d = (_c = column[property]) !== null && _c !== void 0 ? _c : column.minWidth) !== null && _d !== void 0 ? _d : 0;
}
export function findIndexOfColumn(column, reactTableInstance) {
    return reactTableInstance.allColumns.findIndex(({ id }) => id === (column === null || column === void 0 ? void 0 : column.id));
}
export function getTotalColumnResizingWidth(column, columnResizingWidths, reactTableInstance) {
    const flatListOfSubColumns = getFlatListOfSubColumns(column);
    const indexOfFirstSubColumn = findIndexOfColumn(flatListOfSubColumns[0], reactTableInstance);
    let value = 0;
    let isPivoting = false;
    flatListOfSubColumns.forEach((_, index) => {
        var _a, _b;
        const resizingWidth = columnResizingWidths.get(indexOfFirstSubColumn + index);
        value += (_a = resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value) !== null && _a !== void 0 ? _a : 0;
        isPivoting = isPivoting || ((_b = resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.isPivoting) !== null && _b !== void 0 ? _b : false);
    });
    return { isPivoting, value };
}
export function getFlatListOfSubColumns(column) {
    var _a;
    if (isParentColumn(column)) {
        return ((_a = column.columns) !== null && _a !== void 0 ? _a : []).flatMap((c) => getFlatListOfSubColumns(c));
    }
    return [column];
}
export function isParentColumn(column) {
    var _a, _b;
    return ((_b = (_a = column.columns) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) > 0;
}
export function isFlexbileColumn(column) {
    return !column.width && !isParentColumn(column);
}
export function computeNewSubColumnResizingWidths(args) {
    const flatListOfSubColumns = getFlatListOfSubColumns(args.column);
    const indexOfFirstSubColumn = findIndexOfColumn(flatListOfSubColumns[0], args.reactTableInstance);
    const subColumns = flatListOfSubColumns.map(({ minWidth, width, isWidthPinned }) => {
        var _a;
        return ({
            minWidth: minWidth !== null && minWidth !== void 0 ? minWidth : 0,
            currentWidth: (_a = width !== null && width !== void 0 ? width : minWidth) !== null && _a !== void 0 ? _a : 0,
            isFrozen: isWidthPinned !== null && isWidthPinned !== void 0 ? isWidthPinned : false,
        });
    });
    const fixedWidthAmount = subColumns.reduce((acc, { isFrozen, currentWidth, minWidth }) => (isFrozen ? acc + (currentWidth !== null && currentWidth !== void 0 ? currentWidth : minWidth) : acc), 0);
    const nextTotalWidth = args.newTotalWidth - fixedWidthAmount;
    const apportionedWidths = apportionColumnWidths(nextTotalWidth, subColumns);
    const newColumnResizingWidths = apportionedWidths.reduce((acc, nextWidth, index) => {
        var _a;
        const columnIndex = indexOfFirstSubColumn + index;
        if ((_a = subColumns[index]) === null || _a === void 0 ? void 0 : _a.isFrozen) {
            return acc;
        }
        acc.set(columnIndex, { isPivoting: args.isPivoting, value: nextWidth });
        return acc;
    }, new Map());
    return newColumnResizingWidths;
}
//# sourceMappingURL=FillingColumnResizingWidth.js.map