import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { BeeTableHeaderVisibility } from "../../api";
import { BeeTableTdForAdditionalRow } from "./BeeTableTdForAdditionalRow";
import { BeeTableTd } from "./BeeTableTd";
import { BeeTableCoordinatesContextProvider } from "../../selection/BeeTableSelectionContext";
export function BeeTableBody({ reactTableInstance, additionalRow, headerVisibility, getRowKey, getColumnKey, onRowAdded, onDataCellClick, onDataCellKeyUp, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, resizerStopBehavior, lastColumnMinWidth, rowWrapper, }) {
    const renderRow = useCallback((row, rowIndex) => {
        reactTableInstance.prepareRow(row);
        const renderTr = () => (_jsx("tr", Object.assign({ className: rowKey, "data-testid": `expression-row-${rowIndex}` }, { children: row.cells.map((cell, cellIndex) => {
                const columnKey = getColumnKey(reactTableInstance.allColumns[cellIndex]);
                return (_jsx(React.Fragment, { children: ((cell.column.isRowIndexColumn && shouldRenderRowIndexColumn) || !cell.column.isRowIndexColumn) && (_jsx(BeeTableTd, { resizerStopBehavior: resizerStopBehavior, shouldShowRowsInlineControls: shouldShowRowsInlineControls, columnIndex: cellIndex, row: row, rowIndex: rowIndex, column: reactTableInstance.allColumns[cellIndex], onDataCellClick: onDataCellClick, onDataCellKeyUp: onDataCellKeyUp, onRowAdded: onRowAdded, isActive: false, shouldRenderInlineButtons: shouldRenderRowIndexColumn
                            ? reactTableInstance.allColumns[cellIndex].isRowIndexColumn
                            : cellIndex === 1, lastColumnMinWidth: cellIndex === reactTableInstance.allColumns.length - 1 ? lastColumnMinWidth : undefined })) }, columnKey));
            }) }), rowKey));
        const RowWrapper = rowWrapper;
        const rowKey = getRowKey(row);
        return (_jsx(React.Fragment, { children: RowWrapper ? (_jsx(RowWrapper, Object.assign({ rowIndex: rowIndex, row: row.original }, { children: renderTr() }))) : (_jsx(_Fragment, { children: renderTr() })) }, rowKey));
    }, [
        reactTableInstance,
        rowWrapper,
        getRowKey,
        getColumnKey,
        shouldRenderRowIndexColumn,
        resizerStopBehavior,
        shouldShowRowsInlineControls,
        onDataCellClick,
        onDataCellKeyUp,
        onRowAdded,
        lastColumnMinWidth,
    ]);
    const additionalRowIndex = useMemo(() => {
        return reactTableInstance.rows.length;
    }, [reactTableInstance.rows.length]);
    return (_jsxs("tbody", Object.assign({ className: `${headerVisibility === BeeTableHeaderVisibility.None ? "missing-header" : ""}` }, reactTableInstance.getTableBodyProps(), { children: [reactTableInstance.rows.map((row, rowIndex) => {
                return renderRow(row, rowIndex);
            }), additionalRow && (_jsxs("tr", Object.assign({ className: "additional-row", "data-ouia-component-id": "additional-row" }, { children: [shouldRenderRowIndexColumn && (_jsx(BeeTableCoordinatesContextProvider, Object.assign({ coordinates: { rowIndex: additionalRowIndex, columnIndex: 0 } }, { children: _jsx(BeeTableTdForAdditionalRow, { row: undefined, rowIndex: additionalRowIndex, columnIndex: 0, column: reactTableInstance.allColumns[0], isLastColumn: false, isEmptyCell: true, resizerStopBehavior: resizerStopBehavior }) }))), additionalRow.map((elem, elemIndex) => {
                        const columnIndex = elemIndex + 1;
                        return (_jsx(BeeTableCoordinatesContextProvider, Object.assign({ coordinates: { rowIndex: additionalRowIndex, columnIndex } }, { children: _jsx(BeeTableTdForAdditionalRow, Object.assign({ row: undefined, rowIndex: additionalRowIndex, column: reactTableInstance.allColumns[columnIndex], columnIndex: columnIndex, isLastColumn: elemIndex === additionalRow.length - 1, isEmptyCell: false, resizerStopBehavior: resizerStopBehavior, lastColumnMinWidth: columnIndex === additionalRow.length - 1 ? lastColumnMinWidth : undefined }, { children: elem }), columnIndex) }), columnIndex));
                    })] })))] })));
}
//# sourceMappingURL=BeeTableBody.js.map