import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { FeelInput } from "@kie-tools/feel-input-component";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { NavigationKeysUtils } from "../../keysUtils/keyUtils";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import "./BeeTableEditableCellContent.css";
const CELL_LINE_HEIGHT = 20;
const MONACO_OPTIONS = {
    fixedOverflowWidgets: true,
    lineNumbers: "off",
    fontSize: 13,
    renderLineHighlight: "none",
    lineDecorationsWidth: 1,
    automaticLayout: true,
    "semanticHighlighting.enabled": true,
};
var Mode;
(function (Mode) {
    Mode[Mode["Read"] = 0] = "Read";
    Mode[Mode["Edit"] = 1] = "Edit";
})(Mode || (Mode = {}));
export function BeeTableEditableCellContent({ value, onChange, isReadOnly, isEditing, isActive, setEditing, onFeelTabKeyDown, onFeelEnterKeyDown, expressionId, }) {
    const [cellHeight, setCellHeight] = useState(CELL_LINE_HEIGHT * 3);
    const [preview, setPreview] = useState(value);
    const [previousValue, setPreviousValue] = useState(value);
    const [editingValue, setEditingValue] = useState(value);
    const feelInputRef = useRef(null);
    const mode = useMemo(() => {
        return isEditing && !isReadOnly ? Mode.Edit : Mode.Read;
    }, [isEditing, isReadOnly]);
    const { onRequestFeelVariables } = useBoxedExpressionEditor();
    const feelVariables = useMemo(() => {
        if (mode === Mode.Edit) {
            return onRequestFeelVariables === null || onRequestFeelVariables === void 0 ? void 0 : onRequestFeelVariables();
        }
        else {
            return undefined;
        }
    }, [mode, onRequestFeelVariables]);
    useEffect(() => {
        setPreviousValue((prev) => (isEditing ? prev : value));
        setEditingValue((prev) => (isEditing ? prev : value));
    }, [isEditing, value]);
    const updateValue = useCallback((newValue) => {
        if (value !== newValue) {
            onChange(newValue);
            setCellHeight(calculateCellHeight(newValue));
        }
    }, [value, onChange]);
    const onFeelBlur = useCallback((valueOnBlur) => {
        updateValue(valueOnBlur);
        setEditing(false);
    }, [setEditing, updateValue]);
    const onFeelKeyDown = useCallback((e, newValue) => {
        var _a, _b, _c, _d, _f, _g;
        const eventKey = (_a = e === null || e === void 0 ? void 0 : e.code) !== null && _a !== void 0 ? _a : "";
        if (NavigationKeysUtils.isTab(eventKey)) {
            if ((_b = feelInputRef.current) === null || _b === void 0 ? void 0 : _b.isSuggestionWidgetOpen()) {
            }
            else {
                updateValue(newValue);
                setEditing(false);
                onFeelTabKeyDown === null || onFeelTabKeyDown === void 0 ? void 0 : onFeelTabKeyDown({ isShiftPressed: e.shiftKey });
                e.preventDefault();
            }
        }
        if (NavigationKeysUtils.isEnter(eventKey)) {
            if (e.ctrlKey || e.metaKey || e.altKey) {
                (_c = feelInputRef.current) === null || _c === void 0 ? void 0 : _c.insertNewLineToMonaco();
            }
            else if ((_d = feelInputRef.current) === null || _d === void 0 ? void 0 : _d.isSuggestionWidgetOpen()) {
            }
            else {
                setEditing(false);
                onFeelEnterKeyDown === null || onFeelEnterKeyDown === void 0 ? void 0 : onFeelEnterKeyDown({ isShiftPressed: e.shiftKey });
            }
        }
        if (NavigationKeysUtils.isEsc(eventKey)) {
            if ((_f = feelInputRef.current) === null || _f === void 0 ? void 0 : _f.isSuggestionWidgetOpen()) {
            }
            else {
                (_g = feelInputRef.current) === null || _g === void 0 ? void 0 : _g.setMonacoValue(previousValue);
                updateValue(previousValue);
                setEditing(false);
            }
        }
    }, [updateValue, setEditing, onFeelTabKeyDown, onFeelEnterKeyDown, previousValue]);
    useEffect(() => {
        setCellHeight(calculateCellHeight(value));
    }, [value]);
    const onFeelChange = useCallback((_e, newValue, newPreview) => {
        setCellHeight(calculateCellHeight(newValue));
        setPreview(newPreview);
    }, []);
    const editableCellRef = useRef(null);
    useEffect(() => {
        var _a;
        if (isActive && !isEditing) {
            (_a = editableCellRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [isActive, isEditing]);
    const cssClass = useMemo(() => {
        return `editable-cell ${mode === Mode.Edit ? "editable-cell--edit-mode" : "editable-cell--read-mode"}`;
    }, [mode]);
    const onKeyDown = useCallback((e) => {
        if (isEditing) {
            e.stopPropagation();
        }
        if (isActive && !isEditing && isEditModeTriggeringKey(e)) {
            setEditingValue("");
            setEditing(true);
        }
    }, [isActive, isEditing, setEditing]);
    return (_jsx(_Fragment, { children: _jsxs("div", Object.assign({ ref: editableCellRef, tabIndex: -1, style: { height: `${cellHeight}px`, outline: "none" }, className: cssClass, onKeyDown: onKeyDown }, { children: [_jsx("span", { className: "editable-cell-value pf-u-text-break-word", dangerouslySetInnerHTML: { __html: preview } }), _jsx("span", Object.assign({ "data-ouia-component-id": "editable-cell-raw-value", className: "editable-cell-raw-value" }, { children: value })), _jsx(FeelInput, { ref: feelInputRef, enabled: mode === Mode.Edit, value: isEditing ? editingValue : value, onKeyDown: onFeelKeyDown, onChange: onFeelChange, onPreviewChanged: setPreview, options: MONACO_OPTIONS, onBlur: onFeelBlur, feelVariables: feelVariables, expressionId: expressionId })] })) }));
}
function isEditModeTriggeringKey(e) {
    if (e.altKey || e.ctrlKey || e.metaKey) {
        return false;
    }
    return /^[\s\S]$/.test(e.key);
}
function calculateCellHeight(value) {
    const numberOfValueLines = `${value}`.split("\n").length;
    const numberOfLines = numberOfValueLines <= 2 ? 2 : numberOfValueLines;
    return (numberOfLines + 1) * CELL_LINE_HEIGHT;
}
//# sourceMappingURL=BeeTableEditableCellContent.js.map