import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { ExpressionVariableMenu } from "../../expressionVariable/ExpressionVariableMenu";
import { Resizer } from "../../resizing/Resizer";
import { useBeeTableResizableCell } from "../../resizing/BeeTableResizableColumnsContext";
import { BeeTableTh, getHoverInfo } from "./BeeTableTh";
import { getFlatListOfSubColumns, isFlexbileColumn, isParentColumn, useFillingResizingWidth, } from "../../resizing/FillingColumnResizingWidth";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
export function BeeTableThResizable({ column, columnIndex, rowIndex, shouldRenderRowIndexColumn, rowSpan, isEditableHeader, reactTableInstance, getColumnKey, onExpressionHeaderUpdated, onHeaderClick, onHeaderKeyUp, headerCellInfo, onColumnAdded, resizerStopBehavior, shouldShowColumnsInlineControls, lastColumnMinWidth, onGetWidthToFitData, forwardRef, }) {
    var _a, _b, _c, _d;
    const columnKey = useMemo(() => getColumnKey(column), [column, getColumnKey]);
    const headerCellRef = useRef(null);
    const cssClasses = useMemo(() => {
        var _a;
        const cssClasses = [columnKey, "data-header-cell"];
        if (!column.dataType) {
            cssClasses.push("no-clickable-cell");
        }
        cssClasses.push((_a = column.groupType) !== null && _a !== void 0 ? _a : "");
        return cssClasses.join(" ");
    }, [columnKey, column.dataType, column.groupType]);
    const onClick = useCallback(() => {
        return onHeaderClick === null || onHeaderClick === void 0 ? void 0 : onHeaderClick(columnKey);
    }, [columnKey, onHeaderClick]);
    const onKeyUp = useCallback(() => {
        return onHeaderKeyUp === null || onHeaderKeyUp === void 0 ? void 0 : onHeaderKeyUp(columnKey);
    }, [columnKey, onHeaderKeyUp]);
    const { resizingWidth, setResizingWidth } = useBeeTableResizableCell(columnIndex, resizerStopBehavior, column.width, column.setWidth, column.width ? Math.max((_a = lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : column.minWidth) !== null && _a !== void 0 ? _a : 0, (_b = column.width) !== null && _b !== void 0 ? _b : 0) : undefined);
    const getWidthToFitData = useCallback(() => {
        const extraSpace = 2 +
            16;
        return onGetWidthToFitData() + extraSpace;
    }, [onGetWidthToFitData]);
    const { fillingResizingWidth, setFillingResizingWidth, fillingWidth, setFillingWidth, minFillingWidth, } = useFillingResizingWidth(columnIndex, column, reactTableInstance, shouldRenderRowIndexColumn);
    const [hoverInfo, setHoverInfo] = useState({ isHovered: false });
    const [isResizing, setResizing] = useState(false);
    const { editorRef } = useBoxedExpressionEditor();
    useEffect(() => {
        function hasTextSelectedInBoxedExpressionEditor() {
            var _a;
            const selection = window.getSelection();
            if (selection) {
                return (selection === null || selection === void 0 ? void 0 : selection.toString()) && ((_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.contains(selection.focusNode));
            }
            return false;
        }
        function onEnter(e) {
            e.stopPropagation();
            if (hasTextSelectedInBoxedExpressionEditor()) {
                return;
            }
            setHoverInfo(() => getHoverInfo(e, th));
        }
        function onMove(e) {
            if (hasTextSelectedInBoxedExpressionEditor()) {
                return;
            }
            setHoverInfo(() => getHoverInfo(e, th));
        }
        function onLeave() {
            setHoverInfo(() => ({ isHovered: false }));
        }
        const th = forwardRef === null || forwardRef === void 0 ? void 0 : forwardRef.current;
        th === null || th === void 0 ? void 0 : th.addEventListener("mouseenter", onEnter);
        th === null || th === void 0 ? void 0 : th.addEventListener("mousemove", onMove);
        th === null || th === void 0 ? void 0 : th.addEventListener("mouseleave", onLeave);
        return () => {
            th === null || th === void 0 ? void 0 : th.removeEventListener("mouseleave", onLeave);
            th === null || th === void 0 ? void 0 : th.removeEventListener("mousemove", onMove);
            th === null || th === void 0 ? void 0 : th.removeEventListener("mouseenter", onEnter);
        };
    }, [columnIndex, rowIndex, forwardRef, editorRef]);
    const getAppendToElement = useCallback(() => {
        return headerCellRef.current;
    }, [headerCellRef]);
    return (_jsxs(BeeTableTh, Object.assign({ forwardRef: forwardRef, className: cssClasses, thProps: Object.assign(Object.assign({}, column.getHeaderProps()), { style: {
                width: column.width ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value : "100%",
                minWidth: column.width ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value : "100%",
                maxWidth: isParentColumn(column) || isFlexbileColumn(column)
                    ? fillingWidth
                    : column.width
                        ? resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.value
                        : "100%",
            } }), onClick: onClick, onHeaderKeyUp: onKeyUp, columnKey: columnKey, columnIndex: columnIndex, rowIndex: rowIndex, rowSpan: rowSpan, onColumnAdded: onColumnAdded, groupType: column.groupType, isLastLevelColumn: ((_d = (_c = column.columns) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0) <= 0, shouldShowColumnsInlineControls: shouldShowColumnsInlineControls, column: column }, { children: [_jsx("div", Object.assign({ className: "header-cell", "data-ouia-component-type": "expression-column-header", ref: headerCellRef }, { children: column.dataType && isEditableHeader ? (_jsx(ExpressionVariableMenu, Object.assign({ position: PopoverPosition.bottom, selectedExpressionName: column.label, selectedDataType: column.dataType, onVariableUpdated: onExpressionHeaderUpdated, appendTo: getAppendToElement }, { children: headerCellInfo }))) : (headerCellInfo) })), !column.isWidthConstant &&
                column.width &&
                resizingWidth &&
                (hoverInfo.isHovered || ((resizingWidth === null || resizingWidth === void 0 ? void 0 : resizingWidth.isPivoting) && isResizing)) && (_jsx(Resizer, { minWidth: lastColumnMinWidth !== null && lastColumnMinWidth !== void 0 ? lastColumnMinWidth : column.minWidth, width: column.width, setWidth: column.setWidth, resizingWidth: resizingWidth, setResizingWidth: setResizingWidth, getWidthToFitData: getWidthToFitData, setResizing: setResizing })), getFlatListOfSubColumns(column).some((c) => { var _a; return !((_a = c.isWidthConstant) !== null && _a !== void 0 ? _a : false); }) &&
                (isFlexbileColumn(column) || isParentColumn(column)) &&
                (hoverInfo.isHovered || ((fillingResizingWidth === null || fillingResizingWidth === void 0 ? void 0 : fillingResizingWidth.isPivoting) && isResizing)) && (_jsx(Resizer, { minWidth: minFillingWidth, width: fillingWidth, setWidth: setFillingWidth, resizingWidth: fillingResizingWidth, setResizingWidth: setFillingResizingWidth, getWidthToFitData: getWidthToFitData, setResizing: setResizing }))] })));
}
//# sourceMappingURL=BeeTableThResizable.js.map