"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstantiateBinary = exports.DeleteBuildConfig = exports.CreateBuildConfig = exports.BUILD_CONFIG_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var api_1 = require("./api");
var common_1 = require("../common");
var BUILD_CONFIG_TEMPLATE = function (args) { return ({
    apiVersion: api_1.OpenshiftApiVersions.BUILD_CONFIG,
    kind: "BuildConfig",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
    },
    spec: {
        output: {
            to: {
                kind: "ImageStreamTag",
                name: "".concat(args.resourceName, ":").concat(common_1.BUILD_IMAGE_TAG_VERSION),
            },
        },
        strategy: {
            type: "Docker",
        },
        source: {
            type: "Binary",
            binary: {},
        },
        resources: {
            limits: {
                memory: "4Gi",
            },
        },
    },
}); };
exports.BUILD_CONFIG_TEMPLATE = BUILD_CONFIG_TEMPLATE;
var CreateBuildConfig = (function (_super) {
    __extends(CreateBuildConfig, _super);
    function CreateBuildConfig(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateBuildConfig.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateBuildConfig.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.BUILD_CONFIG_TEMPLATE)(__assign({}, this.args)));
    };
    CreateBuildConfig.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.BUILD_CONFIG, "/namespaces/").concat(this.args.namespace, "/buildconfigs");
    };
    return CreateBuildConfig;
}(ResourceFetch_1.ResourceFetch));
exports.CreateBuildConfig = CreateBuildConfig;
var DeleteBuildConfig = (function (_super) {
    __extends(DeleteBuildConfig, _super);
    function DeleteBuildConfig(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteBuildConfig.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteBuildConfig.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.BUILD_CONFIG, "/namespaces/").concat(this.args.namespace, "/buildconfigs/").concat(this.args.resourceName);
    };
    return DeleteBuildConfig;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteBuildConfig = DeleteBuildConfig;
var InstantiateBinary = (function (_super) {
    __extends(InstantiateBinary, _super);
    function InstantiateBinary(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    InstantiateBinary.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    InstantiateBinary.prototype.body = function () {
        return this.args.zipBlob;
    };
    InstantiateBinary.prototype.contentType = function () {
        return FetchConstants_1.ContentTypes.APPLICATION_ZIP;
    };
    InstantiateBinary.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.BUILD_CONFIG, "/namespaces/").concat(this.args.namespace, "/buildconfigs/").concat(this.args.resourceName, "/instantiatebinary?name=").concat(this.args.resourceName, "&namespace=").concat(this.args.namespace);
    };
    return InstantiateBinary;
}(ResourceFetch_1.ResourceFetch));
exports.InstantiateBinary = InstantiateBinary;
//# sourceMappingURL=BuildConfig.js.map