import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { ResourceDataSource, ResourceDescriptor } from "../common";
export interface ImageStreamSpec {
    lookupPolicy: {
        local: boolean;
    };
}
export interface ImageStreamDescriptor extends ResourceDescriptor {
    spec: ImageStreamSpec;
}
export declare type CreateImageStreamTemplateArgs = {
    resourceDataSource: ResourceDataSource.TEMPLATE;
};
export declare type CreateImageStreamArgs = CreateResourceFetchArgs & (CreateImageStreamTemplateArgs | {
    descriptor: ImageStreamDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const IMAGE_STREAM_TEMPLATE: (args: CreateResourceFetchArgs & CreateImageStreamTemplateArgs) => ImageStreamDescriptor;
export declare class CreateImageStream extends ResourceFetch {
    protected args: CreateImageStreamArgs;
    constructor(args: CreateImageStreamArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class DeleteImageStream extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=ImageStream.d.ts.map