"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteImageStream = exports.CreateImageStream = exports.IMAGE_STREAM_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var api_1 = require("./api");
var common_1 = require("../common");
var IMAGE_STREAM_TEMPLATE = function (args) { return ({
    apiVersion: api_1.OpenshiftApiVersions.IMAGE_STREAM,
    kind: "ImageStream",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
    },
    spec: {
        lookupPolicy: {
            local: true,
        },
    },
}); };
exports.IMAGE_STREAM_TEMPLATE = IMAGE_STREAM_TEMPLATE;
var CreateImageStream = (function (_super) {
    __extends(CreateImageStream, _super);
    function CreateImageStream(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateImageStream.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateImageStream.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.IMAGE_STREAM_TEMPLATE)(__assign({}, this.args)));
    };
    CreateImageStream.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.IMAGE_STREAM, "/namespaces/").concat(this.args.namespace, "/imagestreams");
    };
    return CreateImageStream;
}(ResourceFetch_1.ResourceFetch));
exports.CreateImageStream = CreateImageStream;
var DeleteImageStream = (function (_super) {
    __extends(DeleteImageStream, _super);
    function DeleteImageStream(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteImageStream.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteImageStream.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.IMAGE_STREAM, "/namespaces/").concat(this.args.namespace, "/imagestreams/").concat(this.args.resourceName);
    };
    return DeleteImageStream;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteImageStream = DeleteImageStream;
//# sourceMappingURL=ImageStream.js.map