"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseApiContent = exports.supportArtifactTypes = void 0;
var yaml = __importStar(require("js-yaml"));
var path_browserify_1 = require("path-browserify");
var api_1 = require("../../api");
var AsyncApiParser_1 = require("./impl/asyncapi/AsyncApiParser");
var JsonSchemaParser_1 = require("./impl/jsonschema/JsonSchemaParser");
var OpenApiParser_1 = require("./impl/openapi/OpenApiParser");
var CamelRoutesParser_1 = require("./impl/camelRoutes/CamelRoutesParser");
var specParsers = [
    new OpenApiParser_1.OpenApiParser(),
    new AsyncApiParser_1.AsyncApiParser(),
    new JsonSchemaParser_1.JsonSchemaParser(),
    new CamelRoutesParser_1.CamelRoutesParser(),
];
exports.supportArtifactTypes = [
    api_1.SupportArtifactTypes.Openapi,
    api_1.SupportArtifactTypes.Asyncapi,
];
function parseApiContent(args) {
    return serviceFileContentToApiDocument(args);
}
exports.parseApiContent = parseApiContent;
function serviceFileContentToApiDocument(args) {
    var specContent;
    if (path_browserify_1.posix.extname(args.serviceFileName) === ".json") {
        specContent = JSON.parse(args.serviceFileContent);
    }
    else {
        specContent = yaml.load(args.serviceFileContent);
    }
    var parser = specContent && specParsers.find(function (parser) { return parser.canParse(specContent); });
    if (!parser) {
        throw new Error("'".concat(args.serviceFileName, "' is not a supported spec file"));
    }
    return parser.parse(specContent, args);
}
//# sourceMappingURL=parseApiContent.js.map