import { FormJsonSchemaBridge } from "@kie-tools/form/dist/uniforms/FormJsonSchemaBridge";
import { X_DMN_TYPE } from "@kie-tools/extended-services-api";
import { DAYS_AND_TIME_DURATION_FORMAT, YEARS_AND_MONTHS_DURATION_FORMAT } from "@kie-tools/dmn-runner/dist/dmnFormats";
export var Duration;
(function (Duration) {
    Duration[Duration["DaysAndTimeDuration"] = 0] = "DaysAndTimeDuration";
    Duration[Duration["YearsAndMonthsDuration"] = 1] = "YearsAndMonthsDuration";
})(Duration || (Duration = {}));
export class FormDmnJsonSchemaBridge extends FormJsonSchemaBridge {
    constructor(formSchema, validator, i18n) {
        super(formSchema, validator, i18n);
        this.i18n = i18n;
    }
    getType(name) {
        const { format: fieldFormat, type } = super.getField(name);
        if (fieldFormat === DAYS_AND_TIME_DURATION_FORMAT) {
            return String;
        }
        if (fieldFormat === YEARS_AND_MONTHS_DURATION_FORMAT) {
            return String;
        }
        if (type === X_DMN_TYPE.CONTEXT) {
            return X_DMN_TYPE.CONTEXT;
        }
        return super.getType(name);
    }
    getField(name) {
        const field = super.getField(name);
        if ((field === null || field === void 0 ? void 0 : field.format) === DAYS_AND_TIME_DURATION_FORMAT) {
            field.placeholder = this.i18n.dmnSchema.daysAndTimePlaceholder;
        }
        if ((field === null || field === void 0 ? void 0 : field.format) === YEARS_AND_MONTHS_DURATION_FORMAT) {
            field.placeholder = this.i18n.dmnSchema.yearsAndMonthsPlaceholder;
        }
        if ((field === null || field === void 0 ? void 0 : field.format) === "time") {
            field.placeholder = "hh:mm:ss";
        }
        if ((field === null || field === void 0 ? void 0 : field["x-dmn-type"]) === X_DMN_TYPE.CONTEXT) {
            field.placeholder = `{ "x": <value> }`;
        }
        return field;
    }
}
//# sourceMappingURL=FormDmnJsonSchemaBridge.js.map