import React from "react";
import { TextContent, TextVariants, Text, TextList, TextListItem, } from "@patternfly/react-core/dist/js/components/Text";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { ItemDescriptor } from "../ItemDescriptor";
import { componentOuiaProps } from "../../ouiaTools";
export var BulkListType;
(function (BulkListType) {
    BulkListType["PROCESS_INSTANCE"] = "process_instance";
    BulkListType["JOB"] = "job";
    BulkListType["WORKFLOW"] = "workflow";
})(BulkListType || (BulkListType = {}));
export const BulkList = ({ operationResult, ouiaId, ouiaSafe }) => {
    const iterateItems = (itemList) => {
        return (React.createElement(TextList, null, itemList.map((item) => {
            return (React.createElement(TextListItem, { key: item.id },
                React.createElement("strong", null,
                    React.createElement(ItemDescriptor, { itemDescription: item })),
                " ",
                item.errorMessage && React.createElement("span", null,
                    " - ",
                    item.errorMessage)));
        })));
    };
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "bulk-list", ouiaSafe)),
        operationResult.results.successItems.length > 0 ? (React.createElement(React.Fragment, null,
            React.createElement(TextContent, null,
                React.createElement(Text, { component: TextVariants.h2 }, operationResult.messages.successMessage),
                iterateItems(operationResult.results.successItems)),
            operationResult.results.successItems.length !== 0 && operationResult.messages.warningMessage && (React.createElement(TextContent, { className: "pf-u-mt-sm" },
                React.createElement(Text, { component: TextVariants.small }, operationResult.messages.warningMessage))))) : (React.createElement(TextContent, null,
            React.createElement(Text, { component: TextVariants.h2 }, operationResult.messages.noItemsMessage))),
        operationResult.results.ignoredItems.length !== 0 && (React.createElement(React.Fragment, null,
            React.createElement(Divider, { component: "div", className: "pf-u-my-xl" }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: TextVariants.h2 },
                    operationResult.type === BulkListType.PROCESS_INSTANCE && React.createElement("span", null, "Ignored process instances:"),
                    operationResult.type === BulkListType.WORKFLOW && React.createElement("span", null, "Ignored workflows:"),
                    operationResult.type === BulkListType.JOB && React.createElement("span", null, "Ignored jobs:")),
                React.createElement(Text, { component: TextVariants.small, className: "pf-u-mt-sm" },
                    React.createElement("span", null, operationResult.messages.ignoredMessage)),
                iterateItems(operationResult.results.ignoredItems)))),
        operationResult.results.failedItems.length !== 0 && (React.createElement(React.Fragment, null,
            React.createElement(Divider, { component: "div", className: "pf-u-my-xl" }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: TextVariants.h2 }, "Errors:"),
                iterateItems(operationResult.results.failedItems))))));
};
//# sourceMappingURL=BulkList.js.map