import React from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { ExternalLinkAltIcon } from "@patternfly/react-icons/dist/js/icons/external-link-alt-icon";
import { componentOuiaProps } from "../../ouiaTools";
export const EndpointLink = ({ serviceUrl, isLinkShown, linkLabel, ouiaId, ouiaSafe, }) => {
    if (serviceUrl) {
        return (React.createElement(Button, Object.assign({ component: "a", variant: "link", target: "_blank", href: `${serviceUrl}`, isInline: true }, componentOuiaProps(ouiaId, "endpoint-link", ouiaSafe)),
            isLinkShown ? serviceUrl : linkLabel || "Endpoint",
            React.createElement(ExternalLinkAltIcon, { className: "pf-u-ml-xs" })));
    }
    else {
        return React.createElement(React.Fragment, null);
    }
};
//# sourceMappingURL=EndpointLink.js.map