import React, { useState } from "react";
import { Dropdown, DropdownItem, DropdownSeparator, DropdownToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Toolbar, ToolbarGroup, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Avatar } from "@patternfly/react-core/dist/js/components/Avatar";
import accessibleStyles from "@patternfly/react-styles/css/utilities/Accessibility/accessibility";
import { css } from "@patternfly/react-styles";
import AboutModalBox from "../AboutModalBox/AboutModalBox";
import userImage from "../../static/avatar.svg";
import { ANONYMOUS_USER, supportsLogout, useKogitoAppContext, } from "../../contexts/KogitoAppContext";
import { componentOuiaProps } from "../../ouiaTools";
const PageToolbar = ({ ouiaId, ouiaSafe }) => {
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    const [modalToggle, setmodalToggle] = useState(false);
    const context = useKogitoAppContext();
    const handleAboutModalToggle = () => {
        setmodalToggle(!modalToggle);
    };
    const onDropdownToggle = (_isDropdownOpen) => {
        setDropdownOpen(_isDropdownOpen);
    };
    const onDropdownSelect = () => {
        setDropdownOpen(!isDropdownOpen);
    };
    const getUserName = () => {
        if (context) {
            if (context.getCurrentUser() === ANONYMOUS_USER) {
                return "Anonymous";
            }
            return context.getCurrentUser().id;
        }
        return "Anonymous";
    };
    const handleLogout = () => {
        if (supportsLogout(context.userContext)) {
            const logout = context.userContext;
            logout.logout();
        }
    };
    const userDropdownItems = [];
    userDropdownItems.push(React.createElement(DropdownItem, { key: userDropdownItems.length, onClick: handleAboutModalToggle }, "About"));
    if (supportsLogout(context.userContext)) {
        userDropdownItems.push(React.createElement(DropdownSeparator, { key: userDropdownItems.length }));
        userDropdownItems.push(React.createElement(DropdownItem, { key: userDropdownItems.length, onClick: handleLogout }, "Log out"));
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(AboutModalBox, { isOpenProp: modalToggle, handleModalToggleProp: handleAboutModalToggle }),
        React.createElement(Toolbar, Object.assign({}, componentOuiaProps(ouiaId, "page-toolbar", ouiaSafe)),
            React.createElement(ToolbarGroup, null,
                React.createElement(ToolbarItem, { className: css(accessibleStyles.screenReader, accessibleStyles.visibleOnMd) },
                    React.createElement(Dropdown, { isPlain: true, position: "right", onSelect: onDropdownSelect, isOpen: isDropdownOpen, toggle: React.createElement(DropdownToggle, { onToggle: onDropdownToggle, icon: React.createElement(Avatar, { src: userImage, alt: "User Avatar" }) }, getUserName()), dropdownItems: userDropdownItems, "data-testid": "pageToolbar-dropdown" }))))));
};
export default PageToolbar;
//# sourceMappingURL=PageToolbar.js.map