var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { createElement as _createElement } from "react";
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { Drawer, DrawerContent, DrawerContentBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { InfrastructureIcon } from "@patternfly/react-icons/dist/js/icons/infrastructure-icon";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { DataTypesEmptyState } from "./DataTypesEmptyState";
import { DataTypePanel } from "./DataTypePanel";
import { findDataTypeById, isStruct } from "./DataTypeSpec";
import { DataTypeName } from "./DataTypeName";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { invalidInlineFeelNameStyle } from "../feel/InlineFeelNameInput";
import { Dropdown, DropdownItem, DropdownPosition, DropdownToggle, DropdownToggleAction, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE, getClipboard, } from "../clipboard/Clipboard";
import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
import { addTopLevelItemDefinition as _addTopLevelItemDefinition } from "../mutations/addTopLevelItemDefinition";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function DataTypes() {
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var activeItemDefinitionId = useDmnEditorStore(function (s) { return s.dataTypesEditor.activeItemDefinitionId; });
    var _a = __read(useState(""), 2), filter = _a[0], setFilter = _a[1];
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var allTopLevelItemDefinitionUniqueNames = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames; });
    var allDataTypesById = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById; });
    var dataTypesTree = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).dataTypesTree; });
    var activeDataType = useMemo(function () {
        return activeItemDefinitionId ? allDataTypesById.get(activeItemDefinitionId) : undefined;
    }, [activeItemDefinitionId, allDataTypesById]);
    var filteredTree = useMemo(function () {
        return dataTypesTree.filter(function (_a) {
            var dataType = _a.itemDefinition;
            return dataType["@_name"].toLowerCase().includes(filter.toLowerCase());
        });
    }, [filter, dataTypesTree]);
    var editItemDefinition = useCallback(function (id, consumer) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var _b;
            var _c = findDataTypeById({
                definitions: state.dmn.model.definitions,
                itemDefinitionId: id,
                allDataTypesById: allDataTypesById,
            }), itemDefinition = _c.itemDefinition, items = _c.items, index = _c.index;
            (_a = (_b = state.dmn.model.definitions).itemDefinition) !== null && _a !== void 0 ? _a : (_b.itemDefinition = []);
            consumer(itemDefinition, items, index, state.dmn.model.definitions.itemDefinition, state);
        });
    }, [allDataTypesById, dmnEditorStoreApi]);
    var addTopLevelItemDefinition = useCallback(function (partial) {
        dmnEditorStoreApi.setState(function (state) {
            var newItemDefinition = _addTopLevelItemDefinition({
                definitions: state.dmn.model.definitions,
                partial: partial,
            });
            state.dataTypesEditor.activeItemDefinitionId = newItemDefinition["@_id"];
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [dmnEditorStoreApi]);
    var pasteTopLevelItemDefinition = useCallback(function () {
        navigator.clipboard.readText().then(function (text) {
            var e_1, _a;
            var clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
            if (!clipboard) {
                return;
            }
            getNewDmnIdRandomizer()
                .ack({
                json: clipboard.itemDefinitions,
                type: "DMN15__tDefinitions",
                attr: "itemDefinition",
            })
                .randomize();
            try {
                for (var _b = __values(clipboard.itemDefinitions), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var itemDefinition = _c.value;
                    addTopLevelItemDefinition(itemDefinition);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    }, [addTopLevelItemDefinition]);
    var _b = __read(useState(false), 2), isAddDataTypeDropdownOpen = _b[0], setAddDataTypeDropdownOpen = _b[1];
    var extraPropsForDropdownToggleAction = { title: "New Data Type" };
    return (_jsx(_Fragment, { children: (dataTypesTree.length <= 0 && (_jsx(DataTypesEmptyState, { onAdd: function () { return addTopLevelItemDefinition({ typeRef: undefined }); }, onPaste: pasteTopLevelItemDefinition }))) || (_jsx(Drawer, __assign({ isExpanded: true, isInline: true, position: "left", className: "kie-dmn-editor--data-types-container" }, { children: _jsx(DrawerContent, __assign({ panelContent: _jsxs(DrawerPanelContent, __assign({ isResizable: true, minSize: "300px", defaultSize: "400px" }, { children: [_jsx(Flex, __assign({ justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" }, className: "kie-dmn-editor--data-types-filter kie-dmn-editor--sticky-top-glass-header" }, { children: _jsxs(InputGroup, { children: [_jsx(SearchInput, { placeholder: "Filter...", value: filter, onChange: function (_event, value) { return setFilter(value); }, onClear: function () { return setFilter(""); } }), _jsx(Dropdown, { onSelect: function () { return setAddDataTypeDropdownOpen(false); }, menuAppendTo: document.body, toggle: _jsx(DropdownToggle, { id: "add-data-type-toggle", splitButtonItems: [
                                                _createElement(DropdownToggleAction, __assign({}, extraPropsForDropdownToggleAction, { key: "add-data-type-action", "aria-label": "Add Data Type", onClick: function () { return addTopLevelItemDefinition({ typeRef: undefined }); } }),
                                                    _jsx(PlusCircleIcon, {})),
                                            ], splitButtonVariant: "action", onToggle: setAddDataTypeDropdownOpen }), position: DropdownPosition.right, isOpen: isAddDataTypeDropdownOpen, dropdownItems: [
                                            _jsx(DropdownItem, __assign({ onClick: function () { return pasteTopLevelItemDefinition(); }, style: { minWidth: "240px" }, icon: _jsx(PasteIcon, {}) }, { children: "Paste" }), "paste"),
                                        ] })] }) })), _jsx("div", __assign({ className: "kie-dmn-editor--data-types-nav" }, { children: filteredTree.map(function (_a) {
                                var _b;
                                var namespace = _a.namespace, itemDefinition = _a.itemDefinition, feelName = _a.feelName;
                                var isActive = itemDefinition["@_id"] === (activeDataType === null || activeDataType === void 0 ? void 0 : activeDataType.itemDefinition["@_id"]) ||
                                    ((_b = activeDataType === null || activeDataType === void 0 ? void 0 : activeDataType.parents.has(itemDefinition["@_id"])) !== null && _b !== void 0 ? _b : false);
                                return (_jsxs(Flex, __assign({ flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" }, onClick: function () {
                                        return dmnEditorStoreApi.setState(function (state) {
                                            state.dataTypesEditor.activeItemDefinitionId = itemDefinition["@_id"];
                                        });
                                    }, justifyContent: { default: "justifyContentFlexStart" }, alignItems: { default: "alignItemsCenter" }, className: "kie-dmn-editor--data-types-nav-item ".concat(isActive ? "active" : "") }, { children: [_jsx(InfrastructureIcon, { style: { display: "inline", opacity: isStruct(itemDefinition) ? 1 : 0, minWidth: "1em" } }), (namespace === thisDmnsNamespace && (_jsx(DataTypeName, { relativeToNamespace: thisDmnsNamespace, isReadonly: namespace !== thisDmnsNamespace, itemDefinition: itemDefinition, isActive: isActive, editMode: "double-click", enableAutoFocusing: false, onGetAllUniqueNames: function () { return allTopLevelItemDefinitionUniqueNames; } }))) || (_jsxs(_Fragment, { children: [_jsx(Label, __assign({ style: { marginLeft: "8px" } }, { children: "External" })), _jsx("div", __assign({ className: "kie-dmn-editor--editable-node-name-input top-left grow", style: DMN15_SPEC.namedElement.isValidName(itemDefinition["@_id"], feelName, allTopLevelItemDefinitionUniqueNames)
                                                        ? {}
                                                        : invalidInlineFeelNameStyle }, { children: "".concat(feelName) }))] }))] }), itemDefinition["@_id"]));
                            }) }))] })) }, { children: _jsx(DrawerContentBody, { children: activeDataType && (_jsx(DataTypePanel, { isReadonly: activeDataType.namespace !== thisDmnsNamespace, dataType: activeDataType, allDataTypesById: allDataTypesById, editItemDefinition: editItemDefinition })) }) })) }))) }));
}
//# sourceMappingURL=DataTypes.js.map