var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var _a, _b;
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as RF from "reactflow";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, EmptyStateVariant, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { BlueprintIcon } from "@patternfly/react-icons/dist/js/icons/blueprint-icon";
import { InfoIcon } from "@patternfly/react-icons/dist/js/icons/info-icon";
import { MousePointerIcon } from "@patternfly/react-icons/dist/js/icons/mouse-pointer-icon";
import { TableIcon } from "@patternfly/react-icons/dist/js/icons/table-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { VirtualMachineIcon } from "@patternfly/react-icons/dist/js/icons/virtual-machine-icon";
import { useDmnEditor } from "../DmnEditorContext";
import { AutolayoutButton } from "../autolayout/AutolayoutButton";
import { getDefaultColumnWidth } from "../boxedExpressions/getDefaultColumnWidth";
import { getDefaultBoxedExpression } from "../boxedExpressions/getDefaultBoxedExpression";
import { MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS, } from "../externalNodes/ExternalNodesPanel";
import { nodeNatures } from "../mutations/NodeNature";
import { addConnectedNode } from "../mutations/addConnectedNode";
import { addDecisionToDecisionService } from "../mutations/addDecisionToDecisionService";
import { addEdge } from "../mutations/addEdge";
import { addShape } from "../mutations/addShape";
import { addStandaloneNode } from "../mutations/addStandaloneNode";
import { deleteDecisionFromDecisionService } from "../mutations/deleteDecisionFromDecisionService";
import { EdgeDeletionMode, deleteEdge } from "../mutations/deleteEdge";
import { NodeDeletionMode, deleteNode } from "../mutations/deleteNode";
import { repositionNode } from "../mutations/repositionNode";
import { resizeNode } from "../mutations/resizeNode";
import { updateExpression } from "../mutations/updateExpression";
import { OverlaysPanel } from "../overlaysPanel/OverlaysPanel";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
import { DiagramContainerContextProvider } from "./DiagramContainerContext";
import { MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE } from "./DrgNodesPanel";
import { MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE, Palette } from "./Palette";
import { offsetShapePosition, snapShapeDimensions, snapShapePosition } from "./SnapGrid";
import { ConnectionLine } from "./connections/ConnectionLine";
import { PositionalNodeHandleId } from "./connections/PositionalNodeHandles";
import { containment, getDefaultEdgeTypeBetween } from "./connections/graphStructure";
import { checkIsValidConnection } from "./connections/isValidConnection";
import { EdgeMarkers } from "./edges/EdgeMarkers";
import { EDGE_TYPES } from "./edges/EdgeTypes";
import { AssociationEdge, AuthorityRequirementEdge, InformationRequirementEdge, KnowledgeRequirementEdge, } from "./edges/Edges";
import { buildHierarchy } from "./graph/graph";
import { getDmnBoundsCenterPoint, getContainmentRelationship, getHandlePosition, getNodeTypeFromDmnObject, } from "./maths/DmnMaths";
import { DEFAULT_NODE_SIZES, MIN_NODE_SIZES } from "./nodes/DefaultSizes";
import { NODE_TYPES } from "./nodes/NodeTypes";
import { BkmNode, DecisionNode, DecisionServiceNode, GroupNode, InputDataNode, KnowledgeSourceNode, TextAnnotationNode, UnknownNode, } from "./nodes/Nodes";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { xmlHrefToQName } from "../xml/xmlHrefToQName";
import { addAutoGeneratedDecisionServiceToDrd, addConflictingDecisionServiceToDrd, StrategyForAddingDecisionServiceToDrd, addExistingDecisionServiceToDrd, getStrategyToAddExistingDecisionServiceToDrd, getDecisionServicePropertiesRelativeToThisDmn, } from "../mutations/addExistingDecisionServiceToDrd";
import { updateExpressionWidths } from "../mutations/updateExpressionWidths";
import { DiagramCommands } from "./DiagramCommands";
import { getAutoLayoutedInfo } from "../autolayout/autoLayoutInfo";
import { autoGenerateDrd } from "../normalization/autoGenerateDrd";
import { normalize } from "../normalization/normalize";
import OptimizeIcon from "@patternfly/react-icons/dist/js/icons/optimize-icon";
import { applyAutoLayoutToDrd } from "../mutations/applyAutoLayoutToDrd";
var isFirefox = typeof window.InstallTrigger !== "undefined";
var PAN_ON_DRAG = [1, 2];
var FIT_VIEW_OPTIONS = { maxZoom: 1, minZoom: 0.1, duration: 400 };
export var DEFAULT_VIEWPORT = { x: 100, y: 100, zoom: 1 };
var DELETE_NODE_KEY_CODES = ["Backspace", "Delete"];
var AREA_ABOVE_OVERLAYS_PANEL = 120;
var nodeTypes = (_a = {},
    _a[NODE_TYPES.decisionService] = DecisionServiceNode,
    _a[NODE_TYPES.group] = GroupNode,
    _a[NODE_TYPES.inputData] = InputDataNode,
    _a[NODE_TYPES.decision] = DecisionNode,
    _a[NODE_TYPES.bkm] = BkmNode,
    _a[NODE_TYPES.knowledgeSource] = KnowledgeSourceNode,
    _a[NODE_TYPES.textAnnotation] = TextAnnotationNode,
    _a[NODE_TYPES.unknown] = UnknownNode,
    _a);
var edgeTypes = (_b = {},
    _b[EDGE_TYPES.informationRequirement] = InformationRequirementEdge,
    _b[EDGE_TYPES.authorityRequirement] = AuthorityRequirementEdge,
    _b[EDGE_TYPES.knowledgeRequirement] = KnowledgeRequirementEdge,
    _b[EDGE_TYPES.association] = AssociationEdge,
    _b);
export var Diagram = React.forwardRef(function (_a, ref) {
    var _b;
    var container = _a.container;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var dmnModelBeforeEditingRef = useDmnEditor().dmnModelBeforeEditingRef;
    var _c = __read(useState(undefined), 2), reactFlowInstance = _c[0], setReactFlowInstance = _c[1];
    React.useImperativeHandle(ref, function () { return ({
        getReactFlowInstance: function () {
            return reactFlowInstance;
        },
    }); }, [reactFlowInstance]);
    var nodeIdBeingDraggedRef = useRef(null);
    var rfSnapGrid = useMemo(function () { return (snapGrid.isEnabled ? [snapGrid.x, snapGrid.y] : [1, 1]); }, [snapGrid.isEnabled, snapGrid.x, snapGrid.y]);
    var onConnect = useCallback(function (_a) {
        var source = _a.source, target = _a.target, sourceHandle = _a.sourceHandle, targetHandle = _a.targetHandle;
        console.debug("DMN DIAGRAM: `onConnect`: ", { source: source, target: target, sourceHandle: sourceHandle, targetHandle: targetHandle });
        dmnEditorStoreApi.setState(function (state) {
            var sourceNode = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(source);
            var targetNode = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(target);
            if (!sourceNode || !targetNode) {
                throw new Error("Cannot create connection without target and source nodes!");
            }
            var sourceBounds = sourceNode.data.shape["dc:Bounds"];
            var targetBounds = targetNode.data.shape["dc:Bounds"];
            if (!sourceBounds || !targetBounds) {
                throw new Error("Cannot create connection without target bounds!");
            }
            addEdge({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edge: {
                    type: sourceHandle,
                    targetHandle: targetHandle,
                    sourceHandle: PositionalNodeHandleId.Center,
                    autoPositionedEdgeMarker: undefined,
                },
                sourceNode: {
                    type: sourceNode.type,
                    data: sourceNode.data,
                    href: sourceNode.id,
                    bounds: sourceBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                targetNode: {
                    type: targetNode.type,
                    href: targetNode.id,
                    data: targetNode.data,
                    bounds: targetBounds,
                    index: targetNode.data.index,
                    shapeId: targetNode.data.shape["@_id"],
                },
                keepWaypoints: false,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    var getFirstNodeFittingBounds = useCallback(function (nodeIdToIgnore, bounds, minSizes, snapGrid) {
        return reactFlowInstance === null || reactFlowInstance === void 0 ? void 0 : reactFlowInstance.getNodes().reverse().find(function (node) {
            return node.id !== nodeIdToIgnore &&
                getContainmentRelationship({
                    bounds: bounds,
                    container: node.data.shape["dc:Bounds"],
                    snapGrid: snapGrid,
                    isAlternativeInputDataShape: dmnEditorStoreApi
                        .getState()
                        .computed(dmnEditorStoreApi.getState())
                        .isAlternativeInputDataShape(),
                    containerMinSizes: MIN_NODE_SIZES[node.type],
                    boundsMinSizes: minSizes,
                }).isInside;
        });
    }, [reactFlowInstance, dmnEditorStoreApi]);
    var onDragOver = useCallback(function (e) {
        if (!e.dataTransfer.types.find(function (t) {
            return t === MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE ||
                t === MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS ||
                t === MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE;
        })) {
            return;
        }
        e.preventDefault();
        e.dataTransfer.dropEffect = "move";
    }, []);
    var onDrop = useCallback(function (e) { return __awaiter(void 0, void 0, void 0, function () {
        var dropPoint, typeOfNewNodeFromPalette_1, externalNode_1, state, externalDmnsIndex, externalNodeDmn, externalDrgElement_1, externalNodeType, defaultExternalNodeDimensions_1, externalNodeHref_1, computed, internalState, dereferencedState_1, drdIndex, _a, strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn, drgElement_1, nodeType, _b, computed, state, dereferencedState_2, drdIndex, externalDmnsIndex, _c, strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn;
        var _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    e.preventDefault();
                    if (!container.current || !reactFlowInstance) {
                        return [2];
                    }
                    dropPoint = reactFlowInstance.screenToFlowPosition({
                        x: e.clientX,
                        y: e.clientY,
                    });
                    if (!e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE)) return [3, 1];
                    typeOfNewNodeFromPalette_1 = e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE);
                    e.stopPropagation();
                    dmnEditorStoreApi.setState(function (state) {
                        var _a = addStandaloneNode({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                            newNode: {
                                type: typeOfNewNodeFromPalette_1,
                                bounds: {
                                    "@_x": dropPoint.x,
                                    "@_y": dropPoint.y,
                                    "@_width": DEFAULT_NODE_SIZES[typeOfNewNodeFromPalette_1]({
                                        snapGrid: state.diagram.snapGrid,
                                        isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                    })["@_width"],
                                    "@_height": DEFAULT_NODE_SIZES[typeOfNewNodeFromPalette_1]({
                                        snapGrid: state.diagram.snapGrid,
                                        isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                    })["@_height"],
                                },
                            },
                        }), id = _a.id, newNodeId = _a.href;
                        state.diagram._selectedNodes = [newNodeId];
                        state.focus.consumableId = newNodeId;
                    });
                    return [3, 15];
                case 1:
                    if (!e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS)) return [3, 8];
                    e.stopPropagation();
                    externalNode_1 = JSON.parse(e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS));
                    state = dmnEditorStoreApi.getState();
                    externalDmnsIndex = state
                        .computed(state)
                        .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns;
                    externalNodeDmn = externalDmnsIndex.get(externalNode_1.externalDrgElementNamespace);
                    externalDrgElement_1 = ((_d = externalNodeDmn === null || externalNodeDmn === void 0 ? void 0 : externalNodeDmn.model.definitions.drgElement) !== null && _d !== void 0 ? _d : []).find(function (e) { return e["@_id"] === externalNode_1.externalDrgElementId; });
                    if (!externalNodeDmn || !externalDrgElement_1) {
                        throw new Error("Can't find DRG element with id '".concat(externalNode_1.externalDrgElementId, "' on/or model with namespace '").concat(externalNode_1.externalDrgElementNamespace, "'."));
                    }
                    externalNodeType = getNodeTypeFromDmnObject(externalDrgElement_1);
                    defaultExternalNodeDimensions_1 = DEFAULT_NODE_SIZES[externalNodeType]({
                        snapGrid: state.diagram.snapGrid,
                        isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                    });
                    externalNodeHref_1 = buildXmlHref({
                        namespace: externalNode_1.externalDrgElementNamespace,
                        id: externalNode_1.externalDrgElementId,
                    });
                    if (!(externalDrgElement_1.__$$element === "decisionService")) return [3, 6];
                    computed = state.computed, internalState = __rest(state, ["computed"]);
                    dereferencedState_1 = __assign({ computed: computed }, JSON.parse(JSON.stringify(internalState)));
                    drdIndex = dereferencedState_1.computed(dereferencedState_1).getDrdIndex();
                    _a = getStrategyToAddExistingDecisionServiceToDrd({
                        __readonly_definitions: dereferencedState_1.dmn.model.definitions,
                        __readonly_drgElement: externalDrgElement_1,
                        __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: externalDmnsIndex,
                        __readonly_indexedDrd: dereferencedState_1.computed(dereferencedState_1).indexedDrd(),
                        __readonly_namespace: dereferencedState_1.dmn.model.definitions["@_namespace"],
                    }), strategyForAddingDecisionServiceToDrd = _a.strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction = _a.indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn = _a.decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn = _a.containedDecisionHrefsRelativeToThisDmn;
                    if (!(strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.CONFLICT)) return [3, 2];
                    addConflictingDecisionServiceToDrd({
                        definitions: dereferencedState_1.dmn.model.definitions,
                        __readonly_drdIndex: drdIndex,
                        __readonly_dropPoint: dropPoint,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                    });
                    return [3, 5];
                case 2:
                    if (!(strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE)) return [3, 4];
                    return [4, addAutoGeneratedDecisionServiceToDrd({
                            state: dereferencedState_1,
                            __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                            __readonly_drdIndex: drdIndex,
                            __readonly_externalDmnsIndex: externalDmnsIndex,
                            __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                            __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                            __readonly_snapGrid: dereferencedState_1.diagram.snapGrid,
                            __readonly_dropPoint: dropPoint,
                            __readonly_externalModelsByNamespace: externalModelsByNamespace,
                            __readonly_isAlternativeInputDataShape: dereferencedState_1
                                .computed(dereferencedState_1)
                                .isAlternativeInputDataShape(),
                        })];
                case 3:
                    _e.sent();
                    return [3, 5];
                case 4:
                    if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD) {
                        addExistingDecisionServiceToDrd({
                            definitions: dereferencedState_1.dmn.model.definitions,
                            __readonly_decisionServiceNamespace: externalNodeDmn.model.definitions["@_namespace"],
                            __readonly_drdIndex: drdIndex,
                            __readonly_externalDmnsIndex: dereferencedState_1
                                .computed(dereferencedState_1)
                                .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                            __readonly_indexedDrd: dereferencedState_1.computed(dereferencedState_1).indexedDrd(),
                            __readonly_indexedDrdContainingDecisionServiceDepiction: indexedDrdContainingDecisionServiceDepiction,
                            __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                            __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                            __readonly_dropPoint: dropPoint,
                            __readonly_namespace: dereferencedState_1.dmn.model.definitions["@_namespace"],
                        });
                    }
                    _e.label = 5;
                case 5:
                    dmnEditorStoreApi.setState(function (state) {
                        state.dmn.model = JSON.parse(JSON.stringify(dereferencedState_1.dmn.model));
                        state.diagram._selectedNodes = [externalNodeHref_1];
                    });
                    return [3, 7];
                case 6:
                    dmnEditorStoreApi.setState(function (state) {
                        var externalNodeType = getNodeTypeFromDmnObject(externalDrgElement_1);
                        addShape({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                            nodeType: externalNodeType,
                            shape: {
                                "@_id": generateUuid(),
                                "@_dmnElementRef": xmlHrefToQName(externalNodeHref_1, state.dmn.model.definitions),
                                "dc:Bounds": {
                                    "@_x": dropPoint.x,
                                    "@_y": dropPoint.y,
                                    "@_width": defaultExternalNodeDimensions_1["@_width"],
                                    "@_height": defaultExternalNodeDimensions_1["@_height"],
                                },
                            },
                        });
                        state.diagram._selectedNodes = [externalNodeHref_1];
                    });
                    _e.label = 7;
                case 7:
                    console.debug("DMN DIAGRAM: Adding external node", JSON.stringify(externalNode_1));
                    return [3, 15];
                case 8:
                    if (!e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE)) return [3, 15];
                    drgElement_1 = JSON.parse(e.dataTransfer.getData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE));
                    nodeType = getNodeTypeFromDmnObject(drgElement_1);
                    if (nodeType === undefined) {
                        throw new Error("DMN DIAGRAM: It wasn't possible to determine the node type");
                    }
                    if (!(drgElement_1.__$$element === "decisionService")) return [3, 13];
                    _b = dmnEditorStoreApi.getState(), computed = _b.computed, state = __rest(_b, ["computed"]);
                    dereferencedState_2 = __assign({ computed: computed }, JSON.parse(JSON.stringify(state)));
                    drdIndex = dereferencedState_2.computed(dereferencedState_2).getDrdIndex();
                    externalDmnsIndex = dereferencedState_2
                        .computed(dereferencedState_2)
                        .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns;
                    _c = getStrategyToAddExistingDecisionServiceToDrd({
                        __readonly_definitions: dereferencedState_2.dmn.model.definitions,
                        __readonly_drgElement: drgElement_1,
                        __readonly_decisionServiceNamespace: dereferencedState_2.dmn.model.definitions["@_namespace"],
                        __readonly_drdIndex: drdIndex,
                        __readonly_externalDmnsIndex: externalDmnsIndex,
                        __readonly_indexedDrd: dereferencedState_2.computed(dereferencedState_2).indexedDrd(),
                        __readonly_namespace: dereferencedState_2.dmn.model.definitions["@_namespace"],
                    }), strategyForAddingDecisionServiceToDrd = _c.strategyForAddingDecisionServiceToDrd, indexedDrdContainingDecisionServiceDepiction = _c.indexedDrdContainingDecisionServiceDepiction, decisionServiceHrefRelativeToThisDmn = _c.decisionServiceHrefRelativeToThisDmn, containedDecisionHrefsRelativeToThisDmn = _c.containedDecisionHrefsRelativeToThisDmn;
                    if (!(strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.CONFLICT)) return [3, 9];
                    addConflictingDecisionServiceToDrd({
                        definitions: dereferencedState_2.dmn.model.definitions,
                        __readonly_drdIndex: drdIndex,
                        __readonly_dropPoint: dropPoint,
                        __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                    });
                    return [3, 12];
                case 9:
                    if (!(strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE)) return [3, 11];
                    return [4, addAutoGeneratedDecisionServiceToDrd({
                            state: dereferencedState_2,
                            __readonly_decisionServiceNamespace: dereferencedState_2.dmn.model.definitions["@_namespace"],
                            __readonly_drdIndex: drdIndex,
                            __readonly_externalDmnsIndex: externalDmnsIndex,
                            __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                            __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                            __readonly_snapGrid: dereferencedState_2.diagram.snapGrid,
                            __readonly_dropPoint: dropPoint,
                            __readonly_externalModelsByNamespace: externalModelsByNamespace,
                            __readonly_isAlternativeInputDataShape: dereferencedState_2
                                .computed(dereferencedState_2)
                                .isAlternativeInputDataShape(),
                        })];
                case 10:
                    _e.sent();
                    return [3, 12];
                case 11:
                    if (strategyForAddingDecisionServiceToDrd === StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD) {
                        addExistingDecisionServiceToDrd({
                            definitions: dereferencedState_2.dmn.model.definitions,
                            __readonly_decisionServiceNamespace: dereferencedState_2.dmn.model.definitions["@_namespace"],
                            __readonly_drdIndex: drdIndex,
                            __readonly_externalDmnsIndex: dereferencedState_2
                                .computed(dereferencedState_2)
                                .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                            __readonly_indexedDrd: dereferencedState_2.computed(dereferencedState_2).indexedDrd(),
                            __readonly_indexedDrdContainingDecisionServiceDepiction: indexedDrdContainingDecisionServiceDepiction,
                            __readonly_containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
                            __readonly_decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
                            __readonly_dropPoint: dropPoint,
                            __readonly_namespace: dereferencedState_2.dmn.model.definitions["@_namespace"],
                        });
                    }
                    _e.label = 12;
                case 12:
                    dmnEditorStoreApi.setState(function (state) {
                        state.dmn.model = JSON.parse(JSON.stringify(dereferencedState_2.dmn.model));
                    });
                    return [3, 14];
                case 13:
                    dmnEditorStoreApi.setState(function (state) {
                        var nodeType = getNodeTypeFromDmnObject(drgElement_1);
                        var defaultNodeDimensions = DEFAULT_NODE_SIZES[nodeType]({
                            snapGrid: state.diagram.snapGrid,
                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        });
                        addShape({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                            nodeType: nodeType,
                            shape: {
                                "@_id": generateUuid(),
                                "@_dmnElementRef": buildXmlQName({
                                    type: "xml-qname",
                                    localPart: drgElement_1["@_id"],
                                }),
                                "@_isCollapsed": false,
                                "dc:Bounds": {
                                    "@_x": dropPoint.x,
                                    "@_y": dropPoint.y,
                                    "@_width": defaultNodeDimensions["@_width"],
                                    "@_height": defaultNodeDimensions["@_height"],
                                },
                            },
                        });
                    });
                    _e.label = 14;
                case 14:
                    console.debug("DMN DIAGRAM: Adding DRG node", JSON.stringify(drgElement_1));
                    _e.label = 15;
                case 15: return [2];
            }
        });
    }); }, [container, dmnEditorStoreApi, externalModelsByNamespace, reactFlowInstance]);
    var ongoingConnection = useDmnEditorStore(function (s) { return s.diagram.ongoingConnection; });
    useEffect(function () {
        var edgeUpdaterSource = document.querySelectorAll(".react-flow__edgeupdater-source, .react-flow__edgeupdater-target");
        if (ongoingConnection) {
            edgeUpdaterSource.forEach(function (e) { return e.classList.add("hidden"); });
        }
        else {
            edgeUpdaterSource.forEach(function (e) { return e.classList.remove("hidden"); });
        }
    }, [ongoingConnection]);
    var onConnectStart = useCallback(function (e, newConnection) {
        console.debug("DMN DIAGRAM: `onConnectStart`");
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.ongoingConnection = newConnection;
        });
    }, [dmnEditorStoreApi]);
    var onConnectEnd = useCallback(function (e) {
        console.debug("DMN DIAGRAM: `onConnectEnd`");
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b, _c;
            var targetIsPane = (_b = (_a = e.target) === null || _a === void 0 ? void 0 : _a.classList) === null || _b === void 0 ? void 0 : _b.contains("react-flow__pane");
            if (!targetIsPane || !container.current || !state.diagram.ongoingConnection || !reactFlowInstance) {
                return;
            }
            var dropPoint = reactFlowInstance.screenToFlowPosition({
                x: e.clientX,
                y: e.clientY,
            });
            if (!Object.values(NODE_TYPES).find(function (n) { return n === state.diagram.ongoingConnection.handleId; })) {
                return;
            }
            if (!state.diagram.ongoingConnection.nodeId) {
                return;
            }
            var sourceNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(state.diagram.ongoingConnection.nodeId);
            if (!sourceNode) {
                return;
            }
            var sourceNodeBounds = (_c = state.computed(state).indexedDrd().dmnShapesByHref.get(sourceNode.id)) === null || _c === void 0 ? void 0 : _c["dc:Bounds"];
            if (!sourceNodeBounds) {
                return;
            }
            var newNodeType = state.diagram.ongoingConnection.handleId;
            var sourceNodeType = sourceNode.type;
            var edgeType = getDefaultEdgeTypeBetween(sourceNodeType, newNodeType);
            if (!edgeType) {
                throw new Error("DMN DIAGRAM: Invalid structure: ".concat(sourceNodeType, " --(any)--> ").concat(newNodeType));
            }
            var _d = addConnectedNode({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edgeType: edgeType,
                sourceNode: {
                    href: sourceNode.id,
                    type: sourceNodeType,
                    bounds: sourceNodeBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                newNode: {
                    type: newNodeType,
                    bounds: {
                        "@_x": dropPoint.x,
                        "@_y": dropPoint.y,
                        "@_width": DEFAULT_NODE_SIZES[newNodeType]({
                            snapGrid: state.diagram.snapGrid,
                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        })["@_width"],
                        "@_height": DEFAULT_NODE_SIZES[newNodeType]({
                            snapGrid: state.diagram.snapGrid,
                            isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        })["@_height"],
                    },
                },
            }), id = _d.id, newDmnObejctHref = _d.href;
            state.diagram._selectedNodes = [newDmnObejctHref];
            state.focus.consumableId = newDmnObejctHref;
        });
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.ongoingConnection = undefined;
        });
    }, [dmnEditorStoreApi, container, reactFlowInstance, externalModelsByNamespace]);
    var isValidConnection = useCallback(function (edgeOrConnection) {
        var _a, _b;
        var state = dmnEditorStoreApi.getState();
        var edgeId = state.diagram.edgeIdBeingUpdated;
        var edgeType = edgeId ? (_a = reactFlowInstance === null || reactFlowInstance === void 0 ? void 0 : reactFlowInstance.getEdge(edgeId)) === null || _a === void 0 ? void 0 : _a.type : undefined;
        var ongoingConnectionHierarchy = buildHierarchy({
            nodeId: (_b = state.diagram.ongoingConnection) === null || _b === void 0 ? void 0 : _b.nodeId,
            edges: state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges,
        });
        return (edgeOrConnection.source !== edgeOrConnection.target &&
            checkIsValidConnection(state.computed(state).getDiagramData(externalModelsByNamespace).nodesById, edgeOrConnection, edgeType) &&
            !!edgeOrConnection.target &&
            !ongoingConnectionHierarchy.dependencies.has(edgeOrConnection.target) &&
            !!edgeOrConnection.source &&
            !ongoingConnectionHierarchy.dependents.has(edgeOrConnection.source));
    }, [dmnEditorStoreApi, externalModelsByNamespace, reactFlowInstance]);
    var onNodesChange = useCallback(function (changes) {
        if (!reactFlowInstance) {
            return;
        }
        dmnEditorStoreApi.setState(function (state) {
            var e_1, _a;
            var _b, _c, _d, _e, _f, _g, _h, _j, _k;
            var controlWaypointsByEdge = new Map();
            var _loop_1 = function (change) {
                switch (change.type) {
                    case "add":
                        console.debug("DMN DIAGRAM: 'onNodesChange' --> add '".concat(change.item.id, "'"));
                        state.dispatch(state).diagram.setNodeStatus(change.item.id, { selected: true });
                        break;
                    case "dimensions":
                        console.debug("DMN DIAGRAM: 'onNodesChange' --> dimensions '".concat(change.id, "'"));
                        state.dispatch(state).diagram.setNodeStatus(change.id, { resizing: change.resizing });
                        if (change.dimensions) {
                            var node_1 = state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(change.id);
                            var snappedShape = snapShapeDimensions(state.diagram.snapGrid, node_1.data.shape, MIN_NODE_SIZES[node_1.type]({
                                snapGrid: state.diagram.snapGrid,
                                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                            }));
                            if (snappedShape.width !== change.dimensions.width ||
                                snappedShape.height !== change.dimensions.height) {
                                resizeNode({
                                    definitions: state.dmn.model.definitions,
                                    drdIndex: state.computed(state).getDrdIndex(),
                                    __readonly_dmnShapesByHref: state.computed(state).indexedDrd().dmnShapesByHref,
                                    snapGrid: state.diagram.snapGrid,
                                    __readonly_dmnObjectNamespace: node_1.data.dmnObjectNamespace,
                                    __readonly_externalDmnsIndex: state
                                        .computed(state)
                                        .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                                    change: {
                                        isExternal: !!node_1.data.dmnObjectQName.prefix,
                                        nodeType: node_1.type,
                                        index: node_1.data.index,
                                        shapeIndex: node_1.data.shape.index,
                                        sourceEdgeIndexes: state
                                            .computed(state)
                                            .getDiagramData(externalModelsByNamespace)
                                            .edges.flatMap(function (e) { var _a; return e.source === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                        targetEdgeIndexes: state
                                            .computed(state)
                                            .getDiagramData(externalModelsByNamespace)
                                            .edges.flatMap(function (e) { var _a; return e.target === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                        dimension: {
                                            "@_width": (_c = (_b = change.dimensions) === null || _b === void 0 ? void 0 : _b.width) !== null && _c !== void 0 ? _c : 0,
                                            "@_height": (_e = (_d = change.dimensions) === null || _d === void 0 ? void 0 : _d.height) !== null && _e !== void 0 ? _e : 0,
                                        },
                                    },
                                });
                            }
                        }
                        break;
                    case "position":
                        console.debug("DMN DIAGRAM: 'onNodesChange' --> position '".concat(change.id, "'"));
                        state.dispatch(state).diagram.setNodeStatus(change.id, { dragging: change.dragging });
                        if (change.positionAbsolute) {
                            var node_2 = state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(change.id);
                            var delta = repositionNode({
                                definitions: state.dmn.model.definitions,
                                drdIndex: state.computed(state).getDrdIndex(),
                                controlWaypointsByEdge: controlWaypointsByEdge,
                                change: {
                                    type: "absolute",
                                    nodeType: node_2.type,
                                    selectedEdges: __spreadArray([], __read(state.computed(state).getDiagramData(externalModelsByNamespace).selectedEdgesById.keys()), false),
                                    shapeIndex: node_2.data.shape.index,
                                    sourceEdgeIndexes: state
                                        .computed(state)
                                        .getDiagramData(externalModelsByNamespace)
                                        .edges.flatMap(function (e) { var _a; return e.source === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                    targetEdgeIndexes: state
                                        .computed(state)
                                        .getDiagramData(externalModelsByNamespace)
                                        .edges.flatMap(function (e) { var _a; return e.target === change.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                    position: change.positionAbsolute,
                                },
                            }).delta;
                            if (node_2.type === NODE_TYPES.decisionService && !((_f = node_2.data.shape["@_isCollapsed"]) !== null && _f !== void 0 ? _f : false)) {
                                var decisionService = node_2.data.dmnObject;
                                var containedDecisionHrefsRelativeToThisDmn = getDecisionServicePropertiesRelativeToThisDmn({
                                    thisDmnsNamespace: state.dmn.model.definitions["@_namespace"],
                                    decisionService: decisionService,
                                    decisionServiceNamespace: (_g = node_2.data.dmnObjectNamespace) !== null && _g !== void 0 ? _g : state.dmn.model.definitions["@_namespace"],
                                }).containedDecisionHrefsRelativeToThisDmn;
                                var _loop_2 = function (i) {
                                    var diagramData = state.computed(state).getDiagramData(externalModelsByNamespace);
                                    var nestedNode = diagramData.nodesById.get(containedDecisionHrefsRelativeToThisDmn[i]);
                                    if (((_h = nestedNode === null || nestedNode === void 0 ? void 0 : nestedNode.data) === null || _h === void 0 ? void 0 : _h.shape) === undefined) {
                                        return "continue";
                                    }
                                    var snappedNestedNodeShapeWithAppliedDelta = snapShapePosition(state.diagram.snapGrid, offsetShapePosition(nestedNode.data.shape, delta));
                                    repositionNode({
                                        definitions: state.dmn.model.definitions,
                                        drdIndex: state.computed(state).getDrdIndex(),
                                        controlWaypointsByEdge: controlWaypointsByEdge,
                                        change: {
                                            type: "absolute",
                                            nodeType: nestedNode.type,
                                            selectedEdges: diagramData.edges.map(function (e) { return e.id; }),
                                            shapeIndex: nestedNode.data.shape.index,
                                            sourceEdgeIndexes: diagramData.edges.flatMap(function (e) { var _a; return e.source === nestedNode.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                            targetEdgeIndexes: diagramData.edges.flatMap(function (e) { var _a; return e.target === nestedNode.id && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                                            position: snappedNestedNodeShapeWithAppliedDelta,
                                        },
                                    });
                                };
                                for (var i = 0; i < containedDecisionHrefsRelativeToThisDmn.length; i++) {
                                    _loop_2(i);
                                }
                            }
                        }
                        break;
                    case "remove":
                        console.debug("DMN DIAGRAM: 'onNodesChange' --> remove '".concat(change.id, "'"));
                        var node = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById.get(change.id);
                        deleteNode({
                            definitions: state.dmn.model.definitions,
                            __readonly_drgEdges: state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges,
                            __readonly_drdIndex: state.computed(state).getDrdIndex(),
                            __readonly_dmnObjectNamespace: (_j = node.data.dmnObjectNamespace) !== null && _j !== void 0 ? _j : state.dmn.model.definitions["@_namespace"],
                            __readonly_dmnObjectQName: node.data.dmnObjectQName,
                            __readonly_dmnObjectId: (_k = node.data.dmnObject) === null || _k === void 0 ? void 0 : _k["@_id"],
                            __readonly_nodeNature: nodeNatures[node.type],
                            mode: NodeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                            __readonly_externalModelTypesByNamespace: state
                                .computed(state)
                                .getExternalModelTypesByNamespace(externalModelsByNamespace),
                        });
                        state.dispatch(state).diagram.setNodeStatus(node.id, {
                            selected: false,
                            dragging: false,
                            resizing: false,
                        });
                        break;
                    case "reset":
                        state.dispatch(state).diagram.setNodeStatus(change.item.id, {
                            selected: false,
                            dragging: false,
                            resizing: false,
                        });
                        break;
                    case "select":
                        state.dispatch(state).diagram.setNodeStatus(change.id, { selected: change.selected });
                        break;
                }
            };
            try {
                for (var changes_1 = __values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                    var change = changes_1_1.value;
                    _loop_1(change);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return)) _a.call(changes_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    }, [reactFlowInstance, dmnEditorStoreApi, externalModelsByNamespace]);
    var resetToBeforeEditingBegan = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            state.dmn.model = normalize(dmnModelBeforeEditingRef.current);
            state.diagram.draggingNodes = [];
            state.diagram.draggingWaypoints = [];
            state.diagram.resizingNodes = [];
            state.diagram.dropTargetNode = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi, dmnModelBeforeEditingRef]);
    var onNodeDrag = useCallback(function (e, node) {
        nodeIdBeingDraggedRef.current = node.id;
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b, _c, _d, _e, _f;
            state.diagram.dropTargetNode = getFirstNodeFittingBounds(node.id, {
                "@_x": (_b = (_a = node.positionAbsolute) === null || _a === void 0 ? void 0 : _a.x) !== null && _b !== void 0 ? _b : 0,
                "@_y": (_d = (_c = node.positionAbsolute) === null || _c === void 0 ? void 0 : _c.y) !== null && _d !== void 0 ? _d : 0,
                "@_width": (_e = node.width) !== null && _e !== void 0 ? _e : 0,
                "@_height": (_f = node.height) !== null && _f !== void 0 ? _f : 0,
            }, MIN_NODE_SIZES[node.type], state.diagram.snapGrid);
        });
    }, [dmnEditorStoreApi, getFirstNodeFittingBounds]);
    var onNodeDragStart = useCallback(function (e, node, nodes) {
        dmnModelBeforeEditingRef.current = thisDmn.model;
        onNodeDrag(e, node, nodes);
    }, [thisDmn.model, dmnModelBeforeEditingRef, onNodeDrag]);
    var onNodeDragStop = useCallback(function (e, node) {
        try {
            dmnEditorStoreApi.setState(function (state) {
                console.debug("DMN DIAGRAM: `onNodeDragStop`");
                var nodeBeingDragged = state
                    .computed(state)
                    .getDiagramData(externalModelsByNamespace)
                    .nodesById.get(nodeIdBeingDraggedRef.current);
                nodeIdBeingDraggedRef.current = null;
                if (!nodeBeingDragged) {
                    return;
                }
                var dropTargetNode = dmnEditorStoreApi.getState().diagram.dropTargetNode;
                if (dropTargetNode &&
                    containment.has(dropTargetNode.type) &&
                    !state.computed(state).isDropTargetNodeValidForSelection) {
                    console.debug("DMN DIAGRAM: Invalid containment: '".concat(__spreadArray([], __read(state.computed(state).getDiagramData(externalModelsByNamespace).selectedNodeTypes), false).join("', '"), "' inside '").concat(dropTargetNode.type, "'. Ignoring nodes dropped."));
                    resetToBeforeEditingBegan();
                    return;
                }
                var selectedNodes = __spreadArray([], __read(state.computed(state).getDiagramData(externalModelsByNamespace).selectedNodesById.values()), false);
                state.diagram.dropTargetNode = undefined;
                if (!node.dragging) {
                    return;
                }
                if (nodeBeingDragged.data.parentRfNode) {
                    var p = state
                        .computed(state)
                        .getDiagramData(externalModelsByNamespace)
                        .nodesById.get(nodeBeingDragged.data.parentRfNode.id);
                    if ((p === null || p === void 0 ? void 0 : p.type) === NODE_TYPES.decisionService && nodeBeingDragged.type === NODE_TYPES.decision) {
                        for (var i = 0; i < selectedNodes.length; i++) {
                            deleteDecisionFromDecisionService({
                                definitions: state.dmn.model.definitions,
                                decisionId: selectedNodes[i].data.dmnObject["@_id"],
                                decisionServiceId: p.data.dmnObject["@_id"],
                            });
                        }
                    }
                    else {
                        console.debug("DMN DIAGRAM: Ignoring '".concat(nodeBeingDragged.type, "' with parent '").concat(dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type, "' dropping somewhere.."));
                    }
                }
                if ((dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type) === NODE_TYPES.decisionService) {
                    for (var i = 0; i < selectedNodes.length; i++) {
                        addDecisionToDecisionService({
                            definitions: state.dmn.model.definitions,
                            drdIndex: state.computed(state).getDrdIndex(),
                            decisionId: selectedNodes[i].data.dmnObject["@_id"],
                            decisionServiceId: state
                                .computed(state)
                                .getDiagramData(externalModelsByNamespace)
                                .nodesById.get(dropTargetNode.id).data.dmnObject["@_id"],
                            snapGrid: state.diagram.snapGrid,
                        });
                    }
                }
                else {
                    console.debug("DMN DIAGRAM: Ignoring '".concat(nodeBeingDragged.type, "' dropped on top of '").concat(dropTargetNode === null || dropTargetNode === void 0 ? void 0 : dropTargetNode.type, "'"));
                }
            });
        }
        catch (e) {
            console.error(e);
            resetToBeforeEditingBegan();
        }
    }, [dmnEditorStoreApi, externalModelsByNamespace, resetToBeforeEditingBegan]);
    var onEdgesChange = useCallback(function (changes) {
        dmnEditorStoreApi.setState(function (state) {
            var e_2, _a;
            try {
                for (var changes_2 = __values(changes), changes_2_1 = changes_2.next(); !changes_2_1.done; changes_2_1 = changes_2.next()) {
                    var change = changes_2_1.value;
                    switch (change.type) {
                        case "select":
                            console.debug("DMN DIAGRAM: 'onEdgesChange' --> select '".concat(change.id, "'"));
                            state.dispatch(state).diagram.setEdgeStatus(change.id, { selected: change.selected });
                            break;
                        case "remove":
                            console.debug("DMN DIAGRAM: 'onEdgesChange' --> remove '".concat(change.id, "'"));
                            var edge = state.computed(state).getDiagramData(externalModelsByNamespace).edgesById.get(change.id);
                            if (edge === null || edge === void 0 ? void 0 : edge.data) {
                                deleteEdge({
                                    definitions: state.dmn.model.definitions,
                                    drdIndex: state.computed(state).getDrdIndex(),
                                    edge: { id: change.id, dmnObject: edge.data.dmnObject },
                                    mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                                });
                                state.dispatch(state).diagram.setEdgeStatus(change.id, {
                                    selected: false,
                                    draggingWaypoint: false,
                                });
                            }
                            break;
                        case "add":
                        case "reset":
                            console.debug("DMN DIAGRAM: 'onEdgesChange' --> add/reset '".concat(change.item.id, "'. Ignoring"));
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (changes_2_1 && !changes_2_1.done && (_a = changes_2.return)) _a.call(changes_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    var onEdgeUpdate = useCallback(function (oldEdge, newConnection) {
        console.debug("DMN DIAGRAM: `onEdgeUpdate`", oldEdge, newConnection);
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b, _c, _d;
            var sourceNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(newConnection.source);
            var targetNode = state
                .computed(state)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(newConnection.target);
            if (!sourceNode || !targetNode) {
                throw new Error("Cannot create connection without target and source nodes!");
            }
            var sourceBounds = sourceNode.data.shape["dc:Bounds"];
            var targetBounds = targetNode.data.shape["dc:Bounds"];
            if (!sourceBounds || !targetBounds) {
                throw new Error("Cannot create connection without target bounds!");
            }
            var lastWaypoint = ((_a = oldEdge.data) === null || _a === void 0 ? void 0 : _a.dmnEdge)
                ? oldEdge.data.dmnEdge["di:waypoint"][oldEdge.data.dmnEdge["di:waypoint"].length - 1]
                : getDmnBoundsCenterPoint(targetBounds);
            var firstWaypoint = ((_b = oldEdge.data) === null || _b === void 0 ? void 0 : _b.dmnEdge)
                ? oldEdge.data.dmnEdge["di:waypoint"][0]
                : getDmnBoundsCenterPoint(sourceBounds);
            var newDmnEdge = addEdge({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                edge: {
                    autoPositionedEdgeMarker: undefined,
                    type: oldEdge.type,
                    targetHandle: ((_c = newConnection.targetHandle) !== null && _c !== void 0 ? _c : getHandlePosition({ shapeBounds: targetBounds, waypoint: lastWaypoint })
                        .handlePosition),
                    sourceHandle: ((_d = newConnection.sourceHandle) !== null && _d !== void 0 ? _d : getHandlePosition({ shapeBounds: sourceBounds, waypoint: firstWaypoint })
                        .handlePosition),
                },
                sourceNode: {
                    type: sourceNode.type,
                    href: sourceNode.id,
                    data: sourceNode.data,
                    bounds: sourceBounds,
                    shapeId: sourceNode.data.shape["@_id"],
                },
                targetNode: {
                    type: targetNode.type,
                    href: targetNode.id,
                    data: targetNode.data,
                    bounds: targetBounds,
                    index: targetNode.data.index,
                    shapeId: targetNode.data.shape["@_id"],
                },
                keepWaypoints: true,
            }).newDmnEdge;
            if (newDmnEdge["@_dmnElementRef"] !== oldEdge.id) {
                var deletedDmnEdgeOnCurrentDrd = deleteEdge({
                    definitions: state.dmn.model.definitions,
                    drdIndex: state.computed(state).getDrdIndex(),
                    edge: { id: oldEdge.id, dmnObject: oldEdge.data.dmnObject },
                    mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                }).deletedDmnEdgeOnCurrentDrd;
                var deletedWaypoints = deletedDmnEdgeOnCurrentDrd === null || deletedDmnEdgeOnCurrentDrd === void 0 ? void 0 : deletedDmnEdgeOnCurrentDrd["di:waypoint"];
                if (oldEdge.source !== newConnection.source && deletedWaypoints) {
                    newDmnEdge["di:waypoint"] = __spreadArray([newDmnEdge["di:waypoint"][0]], __read(deletedWaypoints.slice(1)), false);
                }
                if (oldEdge.target !== newConnection.target && deletedWaypoints) {
                    newDmnEdge["di:waypoint"] = __spreadArray(__spreadArray([], __read(deletedWaypoints.slice(0, deletedWaypoints.length - 1)), false), [
                        newDmnEdge["di:waypoint"][newDmnEdge["di:waypoint"].length - 1],
                    ], false);
                }
            }
            state.diagram._selectedEdges = [newDmnEdge["@_dmnElementRef"]];
            state.diagram.ongoingConnection = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    var onEdgeUpdateStart = useCallback(function (e, edge, handleType) {
        console.debug("DMN DIAGRAM: `onEdgeUpdateStart`");
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.edgeIdBeingUpdated = edge.id;
        });
    }, [dmnEditorStoreApi]);
    var onEdgeUpdateEnd = useCallback(function (e, edge, handleType) {
        console.debug("DMN DIAGRAM: `onEdgeUpdateEnd`");
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.ongoingConnection = undefined;
            state.diagram.edgeIdBeingUpdated = undefined;
        });
    }, [dmnEditorStoreApi]);
    var handleRfKeyDownCapture = useCallback(function (e) {
        var s = dmnEditorStoreApi.getState();
        if (e.key === "Escape") {
            if (s.computed(s).isDiagramEditingInProgress() && dmnModelBeforeEditingRef.current) {
                console.debug("DMN DIAGRAM: Intercepting Escape pressed and preventing propagation. Reverting DMN model to what it was before editing began.");
                e.stopPropagation();
                e.preventDefault();
                resetToBeforeEditingBegan();
            }
            else if (!s.diagram.ongoingConnection) {
                dmnEditorStoreApi.setState(function (state) {
                    if (state.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size > 0 ||
                        state.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size > 0) {
                        console.debug("DMN DIAGRAM: Esc pressed. Desselecting everything.");
                        state.diagram._selectedNodes = [];
                        state.diagram._selectedEdges = [];
                        e.preventDefault();
                    }
                    else if (state.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size <= 0 &&
                        state.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size <= 0) {
                        console.debug("DMN DIAGRAM: Esc pressed. Closing all open panels.");
                        state.diagram.propertiesPanel.isOpen = false;
                        state.diagram.overlaysPanel.isOpen = false;
                        state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                        e.preventDefault();
                    }
                    else {
                    }
                });
            }
            else {
            }
        }
    }, [dmnEditorStoreApi, dmnModelBeforeEditingRef, externalModelsByNamespace, resetToBeforeEditingBegan]);
    var _d = __read(useState(true), 2), showEmptyState = _d[0], setShowEmptyState = _d[1];
    var nodes = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).nodes; });
    var edges = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).edges; });
    var drgElementsWithoutVisualRepresentationOnCurrentDrdLength = useDmnEditorStore(function (s) {
        return s.computed(s).getDiagramData(externalModelsByNamespace).drgElementsWithoutVisualRepresentationOnCurrentDrd
            .length;
    });
    var isEmptyStateShowing = showEmptyState && nodes.length === 0 && drgElementsWithoutVisualRepresentationOnCurrentDrdLength === 0;
    var canAutoGenerateDrd = useDmnEditorStore(function (s) { return s.diagram.autoLayout.canAutoGenerateDrd; });
    var drdsLength = useDmnEditorStore(function (s) { var _a, _b; return (_b = (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b.length; });
    var showAutoGenerateDrdModal = useMemo(function () {
        return canAutoGenerateDrd && drdsLength === undefined;
    }, [canAutoGenerateDrd, drdsLength]);
    return (_jsxs(_Fragment, { children: [showAutoGenerateDrdModal && _jsx(DmnDiagramWithoutDrd, {}), isEmptyStateShowing && !canAutoGenerateDrd && _jsx(DmnDiagramEmptyState, { setShowEmptyState: setShowEmptyState }), _jsxs(DiagramContainerContextProvider, __assign({ container: container }, { children: [_jsx("svg", __assign({ style: { position: "absolute", top: 0, left: 0 } }, { children: _jsx(EdgeMarkers, {}) })), _jsxs(RF.ReactFlow, __assign({ connectionMode: RF.ConnectionMode.Loose, onKeyDownCapture: handleRfKeyDownCapture, nodes: nodes, edges: edges, onNodesChange: onNodesChange, onEdgesChange: onEdgesChange, onEdgeUpdateStart: onEdgeUpdateStart, onEdgeUpdateEnd: onEdgeUpdateEnd, onEdgeUpdate: onEdgeUpdate, onlyRenderVisibleElements: true, zoomOnDoubleClick: false, elementsSelectable: true, panOnScroll: true, zoomOnScroll: false, preventScrolling: true, selectionOnDrag: true, panOnDrag: PAN_ON_DRAG, selectionMode: RF.SelectionMode.Full, isValidConnection: isValidConnection, connectionLineComponent: ConnectionLine, onConnect: onConnect, onConnectStart: onConnectStart, onConnectEnd: onConnectEnd, onNodeDragStart: onNodeDragStart, onNodeDrag: onNodeDrag, onNodeDragStop: onNodeDragStop, nodeTypes: nodeTypes, edgeTypes: edgeTypes, snapToGrid: true, snapGrid: rfSnapGrid, defaultViewport: DEFAULT_VIEWPORT, fitView: false, fitViewOptions: FIT_VIEW_OPTIONS, attributionPosition: "bottom-right", onInit: setReactFlowInstance, deleteKeyCode: DELETE_NODE_KEY_CODES, onDrop: onDrop, onDragOver: onDragOver }, { children: [_jsx(SelectionStatus, {}), _jsx(Palette, { pulse: isEmptyStateShowing }), _jsx(TopRightCornerPanels, { availableHeight: (_b = container.current) === null || _b === void 0 ? void 0 : _b.offsetHeight }), _jsx(DiagramCommands, {}), !isFirefox && _jsx(RF.Background, {}), _jsx(RF.Controls, { fitViewOptions: FIT_VIEW_OPTIONS, position: "bottom-right" }), _jsx(SetConnectionToReactFlowStore, {})] }))] }))] }));
});
function DmnDiagramWithoutDrd() {
    var _this = this;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    return (_jsx(Bullseye, __assign({ style: {
            position: "absolute",
            width: "100%",
            pointerEvents: "none",
            zIndex: 1,
            height: "auto",
            marginTop: "120px",
        } }, { children: _jsxs("div", __assign({ className: "kie-dmn-editor--diagram-empty-state" }, { children: [_jsx(Button, { title: "Close", style: {
                        position: "absolute",
                        top: "8px",
                        right: 0,
                    }, variant: ButtonVariant.plain, icon: _jsx(TimesIcon, {}), onClick: function () {
                        dmnEditorStoreApi.setState(function (s) {
                            s.diagram.autoLayout.canAutoGenerateDrd = false;
                        });
                    } }), _jsxs(EmptyState, __assign({ variant: EmptyStateVariant.small }, { children: [_jsx(EmptyStateIcon, { icon: BlueprintIcon }), _jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "Empty Diagram" })), _jsx(EmptyStateBody, { children: "The current DMN does not have any Diagram associated with it. Do you want to auto-generate it?" }), _jsx(EmptyStatePrimary, { children: _jsx(Button, __assign({ variant: ButtonVariant.link, icon: _jsx(OptimizeIcon, {}), onClick: function () { return __awaiter(_this, void 0, void 0, function () {
                                    var _a, computed, state, dereferencedState, externalModelTypesByNamespace, snapGrid, nodesById, edgesById, nodes, edges, drgEdges, isAlternativeInputDataShape, dmnShapesByHref, _b, __readonly_autoLayoutedInfo, __readonly_parentNodesById;
                                    return __generator(this, function (_c) {
                                        switch (_c.label) {
                                            case 0:
                                                _a = dmnEditorStoreApi.getState(), computed = _a.computed, state = __rest(_a, ["computed"]);
                                                dereferencedState = __assign({ computed: computed }, JSON.parse(JSON.stringify(state)));
                                                externalModelTypesByNamespace = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getExternalModelTypesByNamespace(externalModelsByNamespace);
                                                autoGenerateDrd({
                                                    model: dereferencedState.dmn.model,
                                                    diagram: dereferencedState.diagram,
                                                    externalModelsByNamespace: externalModelsByNamespace,
                                                    externalModelTypesByNamespace: externalModelTypesByNamespace,
                                                });
                                                snapGrid = dereferencedState.diagram.snapGrid;
                                                nodesById = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getDiagramData(externalModelsByNamespace).nodesById;
                                                edgesById = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getDiagramData(externalModelsByNamespace).edgesById;
                                                nodes = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getDiagramData(externalModelsByNamespace).nodes;
                                                edges = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getDiagramData(externalModelsByNamespace).edges;
                                                drgEdges = dereferencedState
                                                    .computed(dereferencedState)
                                                    .getDiagramData(externalModelsByNamespace).drgEdges;
                                                isAlternativeInputDataShape = dereferencedState
                                                    .computed(dereferencedState)
                                                    .isAlternativeInputDataShape();
                                                dmnShapesByHref = dereferencedState.computed(dereferencedState).indexedDrd().dmnShapesByHref;
                                                return [4, getAutoLayoutedInfo({
                                                        __readonly_snapGrid: snapGrid,
                                                        __readonly_nodesById: nodesById,
                                                        __readonly_edgesById: edgesById,
                                                        __readonly_nodes: nodes,
                                                        __readonly_drgEdges: drgEdges,
                                                        __readonly_isAlternativeInputDataShape: isAlternativeInputDataShape,
                                                    })];
                                            case 1:
                                                _b = _c.sent(), __readonly_autoLayoutedInfo = _b.__readonly_autoLayoutedInfo, __readonly_parentNodesById = _b.__readonly_parentNodesById;
                                                dmnEditorStoreApi.setState(function (s) {
                                                    s.diagram.autoLayout.canAutoGenerateDrd = false;
                                                    applyAutoLayoutToDrd({
                                                        state: dereferencedState,
                                                        __readonly_dmnShapesByHref: dmnShapesByHref,
                                                        __readonly_edges: edges,
                                                        __readonly_edgesById: edgesById,
                                                        __readonly_nodesById: nodesById,
                                                        __readonly_autoLayoutedInfo: __readonly_autoLayoutedInfo,
                                                        __readonly_parentNodesById: __readonly_parentNodesById,
                                                        __readonly_drdIndex: dereferencedState.computed(dereferencedState).getDrdIndex(),
                                                        __readonly_dmnObjectNamespace: dereferencedState.dmn.model.definitions["@_namespace"],
                                                        __readonly_externalDmnsIndex: dereferencedState
                                                            .computed(dereferencedState)
                                                            .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                                                    });
                                                    s.dmn.model = dereferencedState.dmn.model;
                                                });
                                                return [2];
                                        }
                                    });
                                }); } }, { children: "Auto-generate Diagram" })) }), _jsx("br", {}), _jsx(EmptyStateBody, __assign({ style: { fontSize: "12px", wordBreak: "break-word" } }, { children: "Auto generating the diagram will automatically place the nodes with the default size and shape. You can also manually build your diagram using the \"DRG Nodes\" option from the palette." }))] }))] })) })));
}
function DmnDiagramEmptyState(_a) {
    var setShowEmptyState = _a.setShowEmptyState;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    return (_jsx(Bullseye, __assign({ style: {
            position: "absolute",
            width: "100%",
            pointerEvents: "none",
            zIndex: 1,
            height: "auto",
            marginTop: "120px",
        } }, { children: _jsxs("div", __assign({ className: "kie-dmn-editor--diagram-empty-state" }, { children: [_jsx(Button, { title: "Close", style: {
                        position: "absolute",
                        top: "8px",
                        right: 0,
                    }, variant: ButtonVariant.plain, icon: _jsx(TimesIcon, {}), onClick: function () { return setShowEmptyState(false); } }), _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: MousePointerIcon }), _jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "This DMN's Diagram is empty" })), _jsx(EmptyStateBody, { children: "Start by dragging nodes from the Palette" }), _jsx("br", {}), _jsx(EmptyStateBody, { children: "or" }), _jsxs(EmptyStatePrimary, { children: [_jsx(Button, __assign({ variant: ButtonVariant.link, icon: _jsx(TableIcon, {}), onClick: function () {
                                        dmnEditorStoreApi.setState(function (state) {
                                            var _a;
                                            var decisionNodeHref = addStandaloneNode({
                                                definitions: state.dmn.model.definitions,
                                                drdIndex: state.computed(state).getDrdIndex(),
                                                newNode: {
                                                    type: NODE_TYPES.decision,
                                                    bounds: {
                                                        "@_x": 100,
                                                        "@_y": 100,
                                                        "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                            snapGrid: state.diagram.snapGrid,
                                                        })["@_width"],
                                                        "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                            snapGrid: state.diagram.snapGrid,
                                                        })["@_height"],
                                                    },
                                                },
                                            }).href;
                                            var drgElementIndex = ((_a = state.dmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).length - 1;
                                            var defaultWidthsById = new Map();
                                            var defaultExpression = getDefaultBoxedExpression({
                                                logicType: "decisionTable",
                                                allTopLevelDataTypesByFeelName: new Map(),
                                                typeRef: undefined,
                                                getDefaultColumnWidth: getDefaultColumnWidth,
                                                widthsById: defaultWidthsById,
                                            });
                                            updateExpression({
                                                definitions: state.dmn.model.definitions,
                                                drgElementIndex: drgElementIndex,
                                                expression: __assign(__assign({}, defaultExpression), { "@_label": "New Decision" }),
                                            });
                                            updateExpressionWidths({
                                                definitions: state.dmn.model.definitions,
                                                drdIndex: state.computed(state).getDrdIndex(),
                                                widthsById: defaultWidthsById,
                                            });
                                            state.dispatch(state).boxedExpressionEditor.open(parseXmlHref(decisionNodeHref).id);
                                        });
                                    } }, { children: "New Decision Table..." })), _jsx("br", {}), _jsx(Button, __assign({ variant: ButtonVariant.link, icon: _jsx(BlueprintIcon, {}), onClick: function () {
                                        dmnEditorStoreApi.setState(function (state) {
                                            var inputDataNodeBounds = {
                                                "@_x": 100,
                                                "@_y": 300,
                                                "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.inputData]({
                                                    snapGrid: state.diagram.snapGrid,
                                                    isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                                })["@_width"],
                                                "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.inputData]({
                                                    snapGrid: state.diagram.snapGrid,
                                                    isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                                                })["@_height"],
                                            };
                                            var _a = addStandaloneNode({
                                                definitions: state.dmn.model.definitions,
                                                drdIndex: state.computed(state).getDrdIndex(),
                                                newNode: {
                                                    type: NODE_TYPES.inputData,
                                                    bounds: inputDataNodeBounds,
                                                },
                                            }), inputDataNodeHref = _a.href, inputDataShapeId = _a.shapeId;
                                            var decisionNodeHref = addConnectedNode({
                                                definitions: state.dmn.model.definitions,
                                                drdIndex: state.computed(state).getDrdIndex(),
                                                edgeType: EDGE_TYPES.informationRequirement,
                                                sourceNode: {
                                                    href: inputDataNodeHref,
                                                    type: NODE_TYPES.inputData,
                                                    bounds: inputDataNodeBounds,
                                                    shapeId: inputDataShapeId,
                                                },
                                                newNode: {
                                                    type: NODE_TYPES.decision,
                                                    bounds: {
                                                        "@_x": 100,
                                                        "@_y": 100,
                                                        "@_width": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                            snapGrid: state.diagram.snapGrid,
                                                        })["@_width"],
                                                        "@_height": DEFAULT_NODE_SIZES[NODE_TYPES.decision]({
                                                            snapGrid: state.diagram.snapGrid,
                                                        })["@_height"],
                                                    },
                                                },
                                            }).href;
                                            state.diagram._selectedNodes = [decisionNodeHref];
                                            state.diagram.propertiesPanel.isOpen = true;
                                        });
                                    } }, { children: "New Decision with Input Data..." }))] })] })] })) })));
}
export function SetConnectionToReactFlowStore(props) {
    var ongoingConnection = useDmnEditorStore(function (s) { return s.diagram.ongoingConnection; });
    var rfStoreApi = RF.useStoreApi();
    useEffect(function () {
        rfStoreApi.setState({
            connectionHandleId: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleId,
            connectionHandleType: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleType,
            connectionNodeId: ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.nodeId,
        });
    }, [ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleId, ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.handleType, ongoingConnection === null || ongoingConnection === void 0 ? void 0 : ongoingConnection.nodeId, rfStoreApi]);
    return _jsx(_Fragment, {});
}
export function TopRightCornerPanels(_a) {
    var availableHeight = _a.availableHeight;
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var togglePropertiesPanel = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.propertiesPanel.isOpen = !state.diagram.propertiesPanel.isOpen;
        });
    }, [dmnEditorStoreApi]);
    var toggleOverlaysPanel = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            state.diagram.overlaysPanel.isOpen = !state.diagram.overlaysPanel.isOpen;
        });
    }, [dmnEditorStoreApi]);
    useLayoutEffect(function () {
        dmnEditorStoreApi.setState(function (state) {
            if (state.diagram.overlaysPanel.isOpen) {
                setTimeout(function () {
                    dmnEditorStoreApi.setState(function (state) {
                        state.diagram.overlaysPanel.isOpen = true;
                    });
                }, 300);
            }
            state.diagram.overlaysPanel.isOpen = false;
        });
    }, [dmnEditorStoreApi, diagram.propertiesPanel.isOpen]);
    return (_jsx(_Fragment, { children: _jsxs(RF.Panel, __assign({ position: "top-right", style: { display: "flex" } }, { children: [_jsx("aside", __assign({ className: "kie-dmn-editor--autolayout-panel-toggle" }, { children: _jsx(AutolayoutButton, {}) })), _jsx("aside", __assign({ className: "kie-dmn-editor--overlays-panel-toggle" }, { children: _jsx(Popover, __assign({ className: "kie-dmn-editor--overlay-panel-popover", "aria-label": "Overlays Panel", position: "bottom-end", enableFlip: false, flipBehavior: ["bottom-end"], hideOnOutsideClick: false, isVisible: diagram.overlaysPanel.isOpen, bodyContent: _jsx(OverlaysPanel, { availableHeight: (availableHeight !== null && availableHeight !== void 0 ? availableHeight : 0) - AREA_ABOVE_OVERLAYS_PANEL }) }, { children: _jsx("button", __assign({ className: "kie-dmn-editor--overlays-panel-toggle-button", onClick: toggleOverlaysPanel, title: "Overlays" }, { children: _jsx(VirtualMachineIcon, { size: "sm" }) })) }), "".concat(diagram.overlaysPanel.isOpen)) })), !diagram.propertiesPanel.isOpen && (_jsx("aside", __assign({ className: "kie-dmn-editor--properties-panel-toggle" }, { children: _jsx("button", __assign({ className: "kie-dmn-editor--properties-panel-toggle-button", onClick: togglePropertiesPanel, title: "Properties panel" }, { children: _jsx(InfoIcon, { size: "sm" }) })) })))] })) }));
}
export function SelectionStatus() {
    var rfStoreApi = RF.useStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var selectedNodesCount = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).selectedNodesById.size; });
    var selectedEdgesCount = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).selectedEdgesById.size; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    useEffect(function () {
        if (selectedNodesCount >= 2) {
            rfStoreApi.setState({ nodesSelectionActive: true });
        }
    }, [rfStoreApi, selectedNodesCount]);
    var onClose = useCallback(function (e) {
        e.stopPropagation();
        dmnEditorStoreApi.setState(function (state) {
            state.diagram._selectedNodes = [];
            state.diagram._selectedEdges = [];
        });
    }, [dmnEditorStoreApi]);
    return (_jsx(_Fragment, { children: (selectedNodesCount + selectedEdgesCount >= 2 && (_jsx(RF.Panel, __assign({ position: "top-center" }, { children: _jsx(Label, __assign({ style: { paddingLeft: "24px" }, onClose: onClose }, { children: (selectedEdgesCount === 0 && "".concat(selectedNodesCount, " nodes selected")) ||
                    (selectedNodesCount === 0 && "".concat(selectedEdgesCount, " edges selected")) ||
                    "".concat(selectedNodesCount, " node").concat(selectedNodesCount === 1 ? "" : "s", ", ").concat(selectedEdgesCount, " edge").concat(selectedEdgesCount === 1 ? "" : "s", " selected") })) })))) || _jsx(_Fragment, {}) }));
}
//# sourceMappingURL=Diagram.js.map