var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as RF from "reactflow";
import { useState, useCallback, useMemo } from "react";
import { addEdgeWaypoint } from "../../mutations/addEdgeWaypoint";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { snapPoint } from "../SnapGrid";
export function usePotentialWaypointControls(waypoints, isEdgeSelected, edgeId, edgeIndex, interactionPathRef) {
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var drdIndex = useDmnEditorStore(function (s) { return s.computed(s).getDrdIndex(); });
    var isDraggingWaypoint = useDmnEditorStore(function (s) { return !!s.diagram.draggingWaypoints.find(function (e) { return e === edgeId; }); });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var reactFlowInstance = RF.useReactFlow();
    var _a = __read(useState(undefined), 2), potentialWaypoint = _a[0], setPotentialWaypoint = _a[1];
    var isConnecting = !!RF.useStore(function (s) { return s.connectionNodeId; });
    var isExistingWaypoint = useCallback(function (point) { return waypoints.find(function (w) { return w["@_x"] === point["@_x"] && w["@_y"] === point["@_y"]; }); }, [waypoints]);
    var onMouseMove = useCallback(function (e) {
        var projectedPoint = reactFlowInstance.screenToFlowPosition({
            x: e.clientX,
            y: e.clientY,
        });
        setPotentialWaypoint(approximateClosestPoint(interactionPathRef.current, [projectedPoint.x, projectedPoint.y]));
    }, [interactionPathRef, reactFlowInstance]);
    var snappedPotentialWaypoint = useMemo(function () {
        if (!potentialWaypoint) {
            return undefined;
        }
        return snapPoint(snapGrid, {
            "@_x": potentialWaypoint.point.x,
            "@_y": potentialWaypoint.point.y,
        });
    }, [snapGrid, potentialWaypoint]);
    var onDoubleClick = useCallback(function () {
        if (!potentialWaypoint || !snappedPotentialWaypoint || edgeIndex === undefined) {
            return;
        }
        if (isExistingWaypoint(snappedPotentialWaypoint)) {
            console.debug("Preventing overlapping waypoint creation.");
            return;
        }
        var i = 1;
        for (var currentLength = 0; currentLength < potentialWaypoint.lengthInPath; i++) {
            currentLength += Math.sqrt(distanceComponentsSquared([waypoints[i]["@_x"], waypoints[i]["@_y"]], {
                x: waypoints[i - 1]["@_x"],
                y: waypoints[i - 1]["@_y"],
            }));
        }
        dmnEditorStoreApi.setState(function (state) {
            addEdgeWaypoint({
                definitions: state.dmn.model.definitions,
                drdIndex: drdIndex,
                beforeIndex: i - 1,
                edgeIndex: edgeIndex,
                waypoint: snappedPotentialWaypoint,
            });
        });
    }, [
        drdIndex,
        dmnEditorStoreApi,
        edgeIndex,
        isExistingWaypoint,
        potentialWaypoint,
        snappedPotentialWaypoint,
        waypoints,
    ]);
    var shouldReturnPotentialWaypoint = isEdgeSelected &&
        !isDraggingWaypoint &&
        snappedPotentialWaypoint &&
        !isExistingWaypoint(snappedPotentialWaypoint) &&
        !isConnecting;
    return {
        isDraggingWaypoint: isDraggingWaypoint,
        onMouseMove: onMouseMove,
        onDoubleClick: onDoubleClick,
        potentialWaypoint: !shouldReturnPotentialWaypoint ? undefined : potentialWaypoint,
    };
}
function approximateClosestPoint(pathNode, point) {
    var pathLength = pathNode.getTotalLength();
    var precision = Math.floor(pathLength / 10);
    var best;
    var bestLength = 0;
    var bestDistance = Infinity;
    var scan;
    var scanDistance;
    for (var scanLength = 0; scanLength <= pathLength; scanLength += precision) {
        scan = pathNode.getPointAtLength(scanLength);
        scanDistance = distanceComponentsSquared(point, scan);
        if (scanDistance < bestDistance) {
            best = scan;
            bestLength = scanLength;
            bestDistance = scanDistance;
        }
    }
    precision /= 2;
    while (precision > 1) {
        var bLength = bestLength - precision;
        var b = pathNode.getPointAtLength(bLength);
        var bDistance = distanceComponentsSquared(point, b);
        if (bLength >= 0 && bDistance < bestDistance) {
            best = b;
            bestLength = bLength;
            bestDistance = bDistance;
            continue;
        }
        var aLength = bestLength + precision;
        var a = pathNode.getPointAtLength(aLength);
        var aDistance = distanceComponentsSquared(point, a);
        if (aLength <= pathLength && aDistance < bestDistance) {
            best = a;
            bestLength = aLength;
            bestDistance = aDistance;
            continue;
        }
        precision /= 2;
    }
    return { point: best, lengthInPath: bestLength };
}
function distanceComponentsSquared(a, b) {
    var dx = b.x - a[0];
    var dy = b.y - a[1];
    return dx * dx + dy * dy;
}
//# sourceMappingURL=usePotentialWaypointControls.js.map