import { DC__Point } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import * as RF from "reactflow";
export declare type Bounds = {
    width: number | undefined | null;
    height: number | undefined | null;
    x: number | undefined | null;
    y: number | undefined | null;
};
export declare function getDiscretelyAutoPositionedEdgeParams(src: Bounds, tgt: Bounds): {
    sx: number;
    sy: number;
    tx: number;
    ty: number;
    sourcePos: RF.Position;
    targetPos: RF.Position;
};
export declare function getPositionalHandlePosition(a: Bounds, b: Bounds): readonly [number, number, RF.Position];
export declare function getCenter(x: number | null | undefined, y: number | null | undefined, width: number | null | undefined, height: number | null | undefined): {
    x: number;
    y: number;
};
export declare function scaleFromCenter(amount: number, node: {
    position: RF.XYPosition | undefined;
    dimensions: Pick<RF.Node, "width" | "height">;
}): {
    position: {
        x: number;
        y: number;
    };
    dimensions: {
        width: number;
        height: number;
    };
};
export declare function getBoundsCenterPoint(node: Bounds | undefined): DC__Point;
//# sourceMappingURL=Maths.d.ts.map