var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addEdge } from "../mutations/addEdge";
import { repositionNode } from "../mutations/repositionNode";
import { resizeNode } from "../mutations/resizeNode";
import { updateDecisionServiceDividerLine } from "../mutations/updateDecisionServiceDividerLine";
import { FAKE_MARKER, visitNodeAndNested } from "../autolayout/autoLayoutInfo";
export function applyAutoLayoutToDrd(_a) {
    var e_1, _b, e_2, _c, e_3, _d, e_4, _e;
    var _f, _g, _h, _j, _k;
    var state = _a.state, __readonly_autoLayoutedInfo = _a.__readonly_autoLayoutedInfo, __readonly_parentNodesById = _a.__readonly_parentNodesById, __readonly_nodesById = _a.__readonly_nodesById, __readonly_edgesById = _a.__readonly_edgesById, __readonly_edges = _a.__readonly_edges, __readonly_dmnShapesByHref = _a.__readonly_dmnShapesByHref, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_dmnObjectNamespace = _a.__readonly_dmnObjectNamespace, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex;
    var autolayoutedElkNodesById = new Map();
    try {
        for (var _l = __values((_f = __readonly_autoLayoutedInfo.nodes) !== null && _f !== void 0 ? _f : []), _m = _l.next(); !_m.done; _m = _l.next()) {
            var topLevelElkNode = _m.value;
            visitNodeAndNested(topLevelElkNode, { x: 100, y: 100 }, function (elkNode, positionOffset) {
                var _a;
                if (elkNode.id.includes(FAKE_MARKER)) {
                    return;
                }
                autolayoutedElkNodesById.set(elkNode.id, elkNode);
                var nodeId = elkNode.id;
                var node = __readonly_nodesById.get(nodeId);
                repositionNode({
                    definitions: state.dmn.model.definitions,
                    drdIndex: __readonly_drdIndex,
                    controlWaypointsByEdge: new Map(),
                    change: {
                        nodeType: node.type,
                        type: "absolute",
                        position: {
                            x: elkNode.x + positionOffset.x,
                            y: elkNode.y + positionOffset.y,
                        },
                        selectedEdges: __spreadArray([], __read(__readonly_edgesById.keys()), false),
                        shapeIndex: (_a = node.data) === null || _a === void 0 ? void 0 : _a.shape.index,
                        sourceEdgeIndexes: __readonly_edges.flatMap(function (e) { var _a; return e.source === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                        targetEdgeIndexes: __readonly_edges.flatMap(function (e) { var _a; return e.target === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                    },
                });
            });
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_m && !_m.done && (_b = _l.return)) _b.call(_l);
        }
        finally { if (e_1) throw e_1.error; }
    }
    try {
        for (var _o = __values((_g = __readonly_autoLayoutedInfo.nodes) !== null && _g !== void 0 ? _g : []), _p = _o.next(); !_p.done; _p = _o.next()) {
            var topLevelElkNode = _p.value;
            visitNodeAndNested(topLevelElkNode, { x: 0, y: 0 }, function (elkNode) {
                var _a;
                if (elkNode.id.includes(FAKE_MARKER)) {
                    return;
                }
                var nodeId = elkNode.id;
                var node = __readonly_nodesById.get(nodeId);
                resizeNode({
                    definitions: state.dmn.model.definitions,
                    drdIndex: __readonly_drdIndex,
                    __readonly_dmnShapesByHref: __readonly_dmnShapesByHref,
                    snapGrid: state.diagram.snapGrid,
                    __readonly_dmnObjectNamespace: __readonly_dmnObjectNamespace,
                    __readonly_externalDmnsIndex: __readonly_externalDmnsIndex,
                    change: {
                        index: node.data.index,
                        isExternal: !!node.data.dmnObjectQName.prefix,
                        nodeType: node.type,
                        dimension: {
                            "@_width": elkNode.width,
                            "@_height": elkNode.height,
                        },
                        shapeIndex: (_a = node.data) === null || _a === void 0 ? void 0 : _a.shape.index,
                        sourceEdgeIndexes: __readonly_edges.flatMap(function (e) { var _a; return e.source === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                        targetEdgeIndexes: __readonly_edges.flatMap(function (e) { var _a; return e.target === nodeId && ((_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) ? [e.data.dmnEdge.index] : []; }),
                    },
                });
            });
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_p && !_p.done && (_c = _o.return)) _c.call(_o);
        }
        finally { if (e_2) throw e_2.error; }
    }
    try {
        for (var __readonly_parentNodesById_1 = __values(__readonly_parentNodesById), __readonly_parentNodesById_1_1 = __readonly_parentNodesById_1.next(); !__readonly_parentNodesById_1_1.done; __readonly_parentNodesById_1_1 = __readonly_parentNodesById_1.next()) {
            var _q = __read(__readonly_parentNodesById_1_1.value, 1), parentNodeId = _q[0];
            var parentNode = __readonly_nodesById.get(parentNodeId);
            if ((parentNode === null || parentNode === void 0 ? void 0 : parentNode.type) !== NODE_TYPES.decisionService) {
                continue;
            }
            var elkNode = autolayoutedElkNodesById.get(parentNodeId);
            if (!elkNode) {
                throw new Error("Couldn't find Decision Service with id ".concat(parentNode.id, " at the autolayouted nodes map"));
            }
            var dividerLinerLocalYPosition = (_j = (_h = elkNode.children) === null || _h === void 0 ? void 0 : _h[1]) === null || _j === void 0 ? void 0 : _j.y;
            if (!dividerLinerLocalYPosition) {
                throw new Error("Couldn't find second child (which represents the Encapuslated Decision section) of Decision Service with id ".concat(parentNode.id, " at the autolayouted nodes map"));
            }
            updateDecisionServiceDividerLine({
                definitions: state.dmn.model.definitions,
                drdIndex: __readonly_drdIndex,
                __readonly_dmnShapesByHref: __readonly_dmnShapesByHref,
                __readonly_dmnObjectNamespace: __readonly_dmnObjectNamespace,
                __readonly_externalDmnsIndex: __readonly_externalDmnsIndex,
                drgElementIndex: parentNode.data.index,
                shapeIndex: parentNode.data.shape.index,
                snapGrid: state.diagram.snapGrid,
                localYPosition: dividerLinerLocalYPosition,
            });
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (__readonly_parentNodesById_1_1 && !__readonly_parentNodesById_1_1.done && (_d = __readonly_parentNodesById_1.return)) _d.call(__readonly_parentNodesById_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    try {
        for (var _r = __values((_k = __readonly_autoLayoutedInfo.edges) !== null && _k !== void 0 ? _k : []), _s = _r.next(); !_s.done; _s = _r.next()) {
            var elkEdge = _s.value;
            if (elkEdge.id.includes(FAKE_MARKER)) {
                continue;
            }
            var edge = __readonly_edgesById.get(elkEdge.id);
            var sourceNode = __readonly_nodesById.get(elkEdge.sources[0]);
            var targetNode = __readonly_nodesById.get(elkEdge.targets[0]);
            if (targetNode.data.dmnObjectQName.prefix) {
                continue;
            }
            addEdge({
                definitions: state.dmn.model.definitions,
                drdIndex: __readonly_drdIndex,
                edge: {
                    autoPositionedEdgeMarker: undefined,
                    type: edge.type,
                    targetHandle: PositionalNodeHandleId.Bottom,
                    sourceHandle: PositionalNodeHandleId.Top,
                },
                sourceNode: {
                    type: sourceNode.type,
                    href: sourceNode.id,
                    data: sourceNode.data,
                    bounds: sourceNode.data.shape["dc:Bounds"],
                    shapeId: sourceNode.data.shape["@_id"],
                },
                targetNode: {
                    type: targetNode.type,
                    href: targetNode.id,
                    data: targetNode.data,
                    bounds: targetNode.data.shape["dc:Bounds"],
                    index: targetNode.data.index,
                    shapeId: targetNode.data.shape["@_id"],
                },
                keepWaypoints: false,
            });
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_s && !_s.done && (_e = _r.return)) _e.call(_r);
        }
        finally { if (e_4) throw e_4.error; }
    }
}
//# sourceMappingURL=applyAutoLayoutToDrd.js.map