import { traverseExpressionsInExpressionHolders, traverseItemDefinitions, traverseTypeRefedInExpressionHolders, } from "../dataTypes/DataTypeSpec";
import { buildFeelQName, parseFeelQName } from "../feel/parseFeelQName";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
export function renameImport(_a) {
    var _b, _c, _d, _e, _f;
    var definitions = _a.definitions, newName = _a.newName, allTopLevelDataTypesByFeelName = _a.allTopLevelDataTypesByFeelName, index = _a.index;
    var trimmedNewName = newName.trim();
    var _import = definitions.import[index];
    traverseItemDefinitions((_b = definitions.itemDefinition) !== null && _b !== void 0 ? _b : [], function (item) {
        var _a;
        if (item.typeRef) {
            var feelQName = parseFeelQName(item.typeRef.__$$text);
            if (((_a = allTopLevelDataTypesByFeelName.get(item.typeRef.__$$text)) === null || _a === void 0 ? void 0 : _a.namespace) === _import["@_namespace"]) {
                item.typeRef = {
                    __$$text: buildFeelQName({
                        type: "feel-qname",
                        importName: trimmedNewName,
                        localPart: feelQName.localPart,
                    }),
                };
            }
        }
    });
    (_c = definitions.drgElement) !== null && _c !== void 0 ? _c : (definitions.drgElement = []);
    for (var i = 0; i < definitions.drgElement.length; i++) {
        var element = definitions.drgElement[i];
        if (element.__$$element === "inputData" ||
            element.__$$element === "decision" ||
            element.__$$element === "businessKnowledgeModel" ||
            element.__$$element === "decisionService") {
            if ((_d = element.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"]) {
                if (((_f = allTopLevelDataTypesByFeelName.get((_e = element.variable) === null || _e === void 0 ? void 0 : _e["@_typeRef"])) === null || _f === void 0 ? void 0 : _f.namespace) === _import["@_namespace"]) {
                    var feelQName = parseFeelQName(element.variable["@_typeRef"]);
                    element.variable["@_typeRef"] = buildFeelQName({
                        type: "feel-qname",
                        importName: trimmedNewName,
                        localPart: feelQName.localPart,
                    });
                }
            }
            if (element.__$$element === "decision" || element.__$$element === "businessKnowledgeModel") {
                traverseExpressionsInExpressionHolders(element, function (expression, __$$element) {
                    var _a, _b;
                    if (__$$element === "functionDefinition") {
                        var e = expression;
                        if (e["@_kind"] === "PMML") {
                            var pmmlDocument = (_a = e.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(function (_a) {
                                var variable = _a.variable;
                                return (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === DMN15_SPEC.BOXED.FUNCTION.PMML.documentFieldName;
                            });
                            var pmmlDocumentLiteralExpression = pmmlDocument === null || pmmlDocument === void 0 ? void 0 : pmmlDocument.expression;
                            if (((_b = pmmlDocumentLiteralExpression === null || pmmlDocumentLiteralExpression === void 0 ? void 0 : pmmlDocumentLiteralExpression.text) === null || _b === void 0 ? void 0 : _b.__$$text) === _import["@_name"]) {
                                pmmlDocumentLiteralExpression.text = { __$$text: trimmedNewName };
                            }
                        }
                    }
                });
                traverseTypeRefedInExpressionHolders(element, function (typeRefed) {
                    var _a;
                    if (typeRefed["@_typeRef"]) {
                        if (((_a = allTopLevelDataTypesByFeelName.get(typeRefed["@_typeRef"])) === null || _a === void 0 ? void 0 : _a.namespace) === _import["@_namespace"]) {
                            var feelQName = parseFeelQName(typeRefed["@_typeRef"]);
                            typeRefed["@_typeRef"] = buildFeelQName({
                                type: "feel-qname",
                                importName: trimmedNewName,
                                localPart: feelQName.localPart,
                            });
                        }
                    }
                });
            }
        }
    }
    _import["@_name"] = trimmedNewName;
}
//# sourceMappingURL=renameImport.js.map