import { findDataTypeById, traverseItemDefinitions, traverseTypeRefedInExpressionHolders, } from "../dataTypes/DataTypeSpec";
export function renameItemDefinition(_a) {
    var _b, _c, _d;
    var definitions = _a.definitions, newName = _a.newName, allDataTypesById = _a.allDataTypesById, itemDefinitionId = _a.itemDefinitionId;
    var dataType = allDataTypesById.get(itemDefinitionId);
    if (!dataType) {
        throw new Error("DMN MUTATION: Can't rename unnexistent item definition. ID ".concat(itemDefinitionId));
    }
    if (dataType.namespace !== definitions["@_namespace"]) {
        throw new Error("DMN MUTATION: Can't rename an external item definition. ID ".concat(itemDefinitionId, ", Namespace: ").concat(dataType.namespace));
    }
    var trimmedNewName = newName.trim();
    var itemDefinition = findDataTypeById({ definitions: definitions, itemDefinitionId: itemDefinitionId, allDataTypesById: allDataTypesById }).itemDefinition;
    if (!(dataType === null || dataType === void 0 ? void 0 : dataType.parentId)) {
        traverseItemDefinitions((_b = definitions.itemDefinition) !== null && _b !== void 0 ? _b : [], function (item) {
            var _a;
            if (((_a = item.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) === itemDefinition["@_name"]) {
                item.typeRef = { __$$text: trimmedNewName };
            }
        });
        (_c = definitions.drgElement) !== null && _c !== void 0 ? _c : (definitions.drgElement = []);
        for (var i = 0; i < definitions.drgElement.length; i++) {
            var element = definitions.drgElement[i];
            if (element.__$$element === "inputData" ||
                element.__$$element === "decision" ||
                element.__$$element === "businessKnowledgeModel" ||
                element.__$$element === "decisionService") {
                if (((_d = element.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"]) === itemDefinition["@_name"]) {
                    element.variable["@_typeRef"] = trimmedNewName;
                }
                if (element.__$$element === "decision" || element.__$$element === "businessKnowledgeModel") {
                    traverseTypeRefedInExpressionHolders(element, function (typeRefed) {
                        if (typeRefed["@_typeRef"] === itemDefinition["@_name"]) {
                            typeRefed["@_typeRef"] = trimmedNewName;
                        }
                    });
                }
            }
        }
    }
    else {
    }
    itemDefinition["@_name"] = trimmedNewName;
}
//# sourceMappingURL=renameItemDefinition.js.map