var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Slider } from "@patternfly/react-core/dist/js/components/Slider";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useLayoutEffect, useRef } from "react";
var MIN_SNAP = 5;
var MAX_SNAP = 50;
var SNAP_STEP = 5;
var BOTTOM_MARGIN = 10;
export function OverlaysPanel(_a) {
    var availableHeight = _a.availableHeight;
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var overlayPanelContainer = useRef(null);
    useLayoutEffect(function () {
        if (overlayPanelContainer.current && availableHeight) {
            var bounds = overlayPanelContainer.current.getBoundingClientRect();
            var currentHeight = bounds.height;
            var yPos = bounds.y;
            if (currentHeight + yPos >= availableHeight) {
                overlayPanelContainer.current.style.height = availableHeight - BOTTOM_MARGIN + "px";
                overlayPanelContainer.current.style.overflowY = "scroll";
            }
            else {
                overlayPanelContainer.current.style.overflowY = "visible";
            }
        }
    });
    return (_jsxs("div", __assign({ ref: overlayPanelContainer }, { children: [_jsxs(Form, __assign({ onKeyDown: function (e) { return e.stopPropagation(); } }, { children: [_jsx(FormGroup, __assign({ label: "Snapping" }, { children: _jsx(Switch, { "aria-label": "Snapping", isChecked: diagram.snapGrid.isEnabled, onChange: function (newValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.snapGrid.isEnabled = newValue;
                                });
                            } }) })), _jsx(FormGroup, __assign({ label: "Horizontal" }, { children: _jsx(Slider, { "data-testid": "kie-tools--dmn-editor--horizontal-snapping-control", className: "kie-dmn-editor--snap-slider", isDisabled: !diagram.snapGrid.isEnabled, value: diagram.snapGrid.x, min: MIN_SNAP, max: MAX_SNAP, isInputVisible: true, inputValue: diagram.snapGrid.x, step: SNAP_STEP, showTicks: true, hasTooltipOverThumb: true, onChange: function (newSliderValue, newInputValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.snapGrid.x = Math.min(MAX_SNAP, Math.max(MIN_SNAP, newInputValue !== null && newInputValue !== void 0 ? newInputValue : newSliderValue));
                                });
                            } }) })), _jsx(FormGroup, __assign({ label: "Vertical" }, { children: _jsx(Slider, { "data-testid": "kie-tools--dmn-editor--vertical-snapping-control", className: "kie-dmn-editor--snap-slider", isDisabled: !diagram.snapGrid.isEnabled, value: diagram.snapGrid.y, min: MIN_SNAP, max: MAX_SNAP, isInputVisible: true, inputValue: diagram.snapGrid.y, step: SNAP_STEP, showTicks: true, hasTooltipOverThumb: true, onChange: function (newSliderValue, newInputValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.snapGrid.y = Math.min(MAX_SNAP, Math.max(MIN_SNAP, newInputValue !== null && newInputValue !== void 0 ? newInputValue : newSliderValue));
                                });
                            } }) }))] })), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsxs(Form, __assign({ onKeyDown: function (e) { return e.stopPropagation(); } }, { children: [_jsx(FormGroup, __assign({ label: "Highlight selected node(s) hierarchy" }, { children: _jsx(Switch, { "aria-label": "Highlight selected node(s) hierarchy", isChecked: diagram.overlays.enableNodeHierarchyHighlight, onChange: function (newValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.overlays.enableNodeHierarchyHighlight = newValue;
                                });
                            } }) })), _jsx(FormGroup, __assign({ label: "Show data type toolbar on nodes" }, { children: _jsx(Switch, { "aria-label": "Show data type toolbar on nodes", isChecked: diagram.overlays.enableDataTypesToolbarOnNodes, onChange: function (newValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.overlays.enableDataTypesToolbarOnNodes = newValue;
                                });
                            } }) })), _jsx(FormGroup, __assign({ label: "Enable styles" }, { children: _jsx(Switch, { "aria-label": "Show data type toolbar on nodes", isChecked: diagram.overlays.enableCustomNodeStyles, onChange: function (newValue) {
                                return dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.overlays.enableCustomNodeStyles = newValue;
                                });
                            } }) }))] }))] })));
}
//# sourceMappingURL=OverlaysPanel.js.map