var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { InformationItemCell } from "./InformationItemCell";
export function RelationInformationItemCell(props) {
    var _a;
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    return (_jsx(_Fragment, { children: _jsx(InformationItemCell, __assign({}, props, { onDescriptionChange: function (newDescription) {
                updater(function (dmnObject) {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                });
            }, onNameChange: function (newName) {
                updater(function (dmnObject) {
                    dmnObject["@_name"] = newName;
                });
            }, onTypeRefChange: function (newTypeRef) {
                updater(function (dmnObject) {
                    dmnObject["@_typeRef"] = newTypeRef;
                });
            } })) }));
}
//# sourceMappingURL=RelationInformationItemCell.js.map