"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashbuilderLanguageServiceCodeCompletion = void 0;
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var code_completions_1 = require("../assets/code-completions/");
exports.DashbuilderLanguageServiceCodeCompletion = {
    getEmptyFileCodeCompletions: function (args) {
        var kind = vscode_languageserver_types_1.CompletionItemKind.Text;
        var label = "Create your first dashboard";
        return Promise.resolve([
            {
                kind: kind,
                label: label,
                detail: "Start with a simple dashboard",
                sortText: "100_".concat(label),
                textEdit: {
                    newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completion: code_completions_1.dashbuilderCompletion, completionItemKind: kind })),
                    range: vscode_languageserver_types_1.Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet,
            },
        ]);
    },
};
//# sourceMappingURL=DashbuilderLanguageServiceCodeCompletion.js.map