import { EditorFactory, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { EditorEnvelopeViewApi, KogitoEditorEnvelopeApiImpl } from "@kie-tools-core/editor/dist/envelope";
import { EnvelopeApiFactoryArgs } from "@kie-tools-core/envelope";
import { ServerlessWorkflowDiagramEditorChannelApi, ServerlessWorkflowDiagramEditorEnvelopeApi } from "../api";
import { ServerlessWorkflowDiagramEditor } from "./ServerlessWorkflowDiagramEditor";
import { Node } from "../api/StunnerEditorEnvelopeAPI";
export declare type ServerlessWorkflowDiagramEnvelopeApiFactoryArgs = EnvelopeApiFactoryArgs<ServerlessWorkflowDiagramEditorEnvelopeApi, ServerlessWorkflowDiagramEditorChannelApi, EditorEnvelopeViewApi<ServerlessWorkflowDiagramEditor>, KogitoEditorEnvelopeContextType<ServerlessWorkflowDiagramEditorChannelApi>>;
export declare class ServerlessWorkflowDiagramEditorEnvelopeApiImpl extends KogitoEditorEnvelopeApiImpl<ServerlessWorkflowDiagramEditor, ServerlessWorkflowDiagramEditorEnvelopeApi, ServerlessWorkflowDiagramEditorChannelApi> implements ServerlessWorkflowDiagramEditorEnvelopeApi {
    private readonly serverlessWorkflowArgs;
    constructor(serverlessWorkflowArgs: ServerlessWorkflowDiagramEnvelopeApiFactoryArgs, editorFactory: EditorFactory<ServerlessWorkflowDiagramEditor, ServerlessWorkflowDiagramEditorChannelApi>);
    editor_session_getAllNodesUUID(): Promise<string[]>;
    editor_session_getEdgeByUUID(uuid: string): Promise<import("../api/StunnerEditorEnvelopeAPI").Edge>;
    editor_session_getNodeByUUID(uuid: string): Promise<Node>;
    editor_session_getDefinitionByElementUUID(uuid: string): Promise<Object>;
    editor_session_getNodeByName(name: string): Promise<Node>;
    editor_session_getNodeName(node: Node): Promise<string>;
    editor_session_getSelectedElementUUID(): Promise<string>;
    editor_session_getSelectedNode(): Promise<Node>;
    editor_session_getSelectedEdge(): Promise<import("../api/StunnerEditorEnvelopeAPI").Edge>;
    editor_session_getSelectedDefinition(): Promise<Object>;
    editor_session_selectByUUID(uuid: string): Promise<void>;
    editor_session_selectByName(name: string): Promise<void>;
    editor_session_clearSelection(): Promise<void>;
    private toStunnerNode;
    private toNode;
    private toEdge;
    private toDefinition;
    editor_canvas_getShapeIds(): Promise<string[]>;
    editor_canvas_getBackgroundColor(uuid: string): Promise<string>;
    editor_canvas_setBackgroundColor(uuid: string, backgroundColor: string): Promise<void>;
    editor_canvas_getBorderColor(uuid: string): Promise<string>;
    editor_canvas_setBorderColor(uuid: string, borderColor: string): Promise<void>;
    editor_canvas_getLocation(uuid: string): Promise<number[]>;
    editor_canvas_getAbsoluteLocation(uuid: string): Promise<number[]>;
    editor_canvas_getDimensions(uuid: string): Promise<number[]>;
    editor_canvas_center(uuid: string): Promise<void>;
    editor_canvas_draw(): Promise<void>;
    kogitoSwfDiagramEditor__highlightNode(args: {
        nodeName: string | null;
    }): Promise<void>;
}
//# sourceMappingURL=ServerlessWorkflowDiagramEditorEnvelopeApiImpl.d.ts.map