"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.consoleDebugMessage = exports.isValidK8sResource = void 0;
function isValidK8sResource(content) {
    return ("apiVersion" in content &&
        typeof content.apiVersion == "string" &&
        "kind" in content &&
        typeof content.kind == "string" &&
        (!("metadata" in content) || ("metadata" in content && typeof content === "object")));
}
exports.isValidK8sResource = isValidK8sResource;
function consoleDebugMessage(message) {
    console.debug("K8S YAML TO APISERVER:", message);
}
exports.consoleDebugMessage = consoleDebugMessage;
//# sourceMappingURL=common.js.map