var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export class JobsManagementGatewayApiImpl {
    constructor(queries) {
        this.initialLoad = (filter, orderBy) => {
            this._JobsManagementState.filters = filter;
            this._JobsManagementState.orderBy = orderBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this._JobsManagementState.filters = filter;
            return Promise.resolve();
        };
        this.cancelJob = (job) => __awaiter(this, void 0, void 0, function* () {
            const cancelResult = yield this.queries.cancelJob(job);
            return cancelResult;
        });
        this.rescheduleJob = (job, repeatInterval, repeatLimit, scheduleDate) => __awaiter(this, void 0, void 0, function* () {
            const rescheduleResult = yield this.queries.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
            return rescheduleResult;
        });
        this.bulkCancel = (jobsToBeActioned) => {
            return this.queries.bulkCancel(jobsToBeActioned);
        };
        this.sortBy = (orderBy) => {
            this._JobsManagementState.orderBy = orderBy;
            return Promise.resolve();
        };
        this.queries = queries;
        this._JobsManagementState = { filters: [], orderBy: {} };
    }
    get jobsManagementState() {
        return this._JobsManagementState;
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getJobs(offset, limit, this._JobsManagementState.filters, this._JobsManagementState.orderBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
}
//# sourceMappingURL=JobsManagementGatewayApi.js.map