import { BulkProcessInstanceActionResponse, ProcessInstance, ProcessInstanceFilter, ProcessListSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { ProcessListQueries } from "./ProcessListQueries";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface ProcessListGatewayApi {
    processListState: ProcessListState;
    initialLoad: (filter: ProcessInstanceFilter, sortBy: ProcessListSortBy) => Promise<void>;
    openProcess: (process: ProcessInstance) => Promise<void>;
    applyFilter: (filter: ProcessInstanceFilter) => Promise<void>;
    applySorting: (SortBy: ProcessListSortBy) => Promise<void>;
    handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType) => Promise<BulkProcessInstanceActionResponse>;
    query(offset: number, limit: number): Promise<ProcessInstance[]>;
    getChildProcessesQuery(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    onOpenProcessListen: (listener: OnOpenProcessListener) => UnSubscribeHandler;
    openTriggerCloudEvent(processInstance?: ProcessInstance): void;
}
export interface ProcessListState {
    filters: ProcessInstanceFilter;
    sortBy: ProcessListSortBy;
}
export interface OnOpenProcessListener {
    onOpen: (process: ProcessInstance) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class ProcessListGatewayApiImpl implements ProcessListGatewayApi {
    private readonly listeners;
    private readonly queries;
    private _ProcessListState;
    constructor(queries: ProcessListQueries);
    get processListState(): ProcessListState;
    openProcess: (process: ProcessInstance) => Promise<void>;
    initialLoad: (filter: ProcessInstanceFilter, sortBy: ProcessListSortBy) => Promise<void>;
    applyFilter: (filter: ProcessInstanceFilter) => Promise<void>;
    applySorting: (sortBy: ProcessListSortBy) => Promise<void>;
    handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    handleProcessMultipleAction: (processInstances: ProcessInstance[], operationType: OperationType) => Promise<BulkProcessInstanceActionResponse>;
    query(offset: number, limit: number): Promise<ProcessInstance[]>;
    getChildProcessesQuery(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    onOpenProcessListen(listener: OnOpenProcessListener): UnSubscribeHandler;
    openTriggerCloudEvent(processInstance?: ProcessInstance): void;
}
//# sourceMappingURL=ProcessListGatewayApi.d.ts.map