"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependencies = void 0;
var Dependencies = (function () {
    function Dependencies() {
        this.singleEdit = {
            iframeContainerTarget: function () {
                var _a, _b, _c;
                return ((_c = (_b = (_a = document.querySelector("[class$='react-code-view-edit']")) === null || _a === void 0 ? void 0 : _a.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement) !== null && _c !== void 0 ? _c : null);
            },
            toolbarContainerTarget: function () {
                var _a, _b, _c;
                return ((_c = (_b = (_a = document.querySelector("[class$='react-code-view-edit']")) === null || _a === void 0 ? void 0 : _a.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement) !== null && _c !== void 0 ? _c : null);
            },
            githubTextEditorToReplaceElement: function () {
                var _a, _b;
                return (_b = (_a = document.querySelector("[class$='react-code-view-edit']")) === null || _a === void 0 ? void 0 : _a.parentElement) !== null && _b !== void 0 ? _b : null;
            },
        };
        this.singleView = {
            iframeContainerTarget: function () {
                return document.getElementById("highlighted-line-menu-positioner");
            },
            toolbarContainerTarget: function () {
                return document.querySelector("[class$='react-code-size-details-banner']");
            },
            githubTextEditorToReplaceElement: function () {
                return document.getElementById("highlighted-line-menu-positioner");
            },
        };
        this.prView = {
            iframeContainerTarget: function (container) {
                return container;
            },
            toolbarContainerTarget: function (container) {
                return container.querySelector(".file-info");
            },
            githubTextEditorToReplaceElement: function (container) {
                return container.querySelector(".js-file-content");
            },
        };
        this.openRepoInExternalEditor = {
            buttonContainerOnRepoHome: function () {
                return document.querySelector(".pagehead-actions");
            },
            buttonContainerOnRepoFilesList: function () {
                var _a;
                return (_a = document.querySelector(".d-flex.gap-2")) === null || _a === void 0 ? void 0 : _a.parentElement;
            },
            buttonContainerOnPrs: function () {
                return document.querySelector(".gh-header-actions");
            },
        };
        this.all = {
            octiconMarkGitHub: function () {
                return document.querySelector(".octicon-mark-github");
            },
            notificationIndicator: function () {
                var _a;
                return ((_a = document.querySelector(".notification-indicator")) !== null && _a !== void 0 ? _a : document.querySelector(".AppHeader-search"));
            },
            notLoggedInNotificationIndicator: function () {
                return document.querySelector("#repository-details-container");
            },
            body: function () {
                return document.body;
            },
            edit__githubFileNameInput: function () {
                return document.querySelector("[aria-describedby=file-name-editor-breadcrumb]");
            },
            edit__githubTextAreaWithFileContents: function () {
                return document.getElementById("kie-tools__initial-content");
            },
            pr__filesMutationObserverTarget: function () {
                return document.getElementById("files");
            },
            pr__commitsMutationObserverTarget: function () {
                return document.getElementById("commits_bucket");
            },
            pr__homeMutationObserverTarget: function () {
                return document.querySelector(".pull-discussion-timeline");
            },
            pr__openWithExternalEditorLinkContainer: function (container) {
                return container.querySelectorAll("details-menu a")[0];
            },
            pr__viewOriginalFileLinkContainer: function (container) {
                return container.querySelectorAll("details-menu a")[0];
            },
            pr__unprocessedFilePathContainer: function (container) {
                return container.querySelector(".file-info a.Link--primary");
            },
            array: {
                pr__supportedPrFileContainers: function () {
                    var elements = Array.from(document.querySelectorAll(".file.js-file.js-details-container")).map(function (e) { return e; });
                    return elements.length > 0 ? elements : null;
                },
                pr__prInfoContainer: function () {
                    var elements = Array.from(document.querySelectorAll(".gh-header-meta .css-truncate-target"));
                    return elements.length > 0 ? elements : null;
                },
            },
            hideDocumentBody: function () {
                document.querySelector("[data-turbo-body]").style.display = "none";
            },
            showDocumentBody: function () {
                document.querySelector("[data-turbo-body]").style.display = "unset";
            },
            getViewFileButton: function () {
                return document.querySelector("a[class='pl-5 dropdown-item btn-link']");
            },
        };
    }
    return Dependencies;
}());
exports.Dependencies = Dependencies;
//# sourceMappingURL=Dependencies.js.map