export interface FormElement {
    reactImports: string[];
    pfImports: string[];
    requiredCode?: string[];
    ref: InputReference;
    stateCode: string;
    jsxCode: string;
    isReadonly: boolean;
}
declare abstract class AbstractFormElement implements FormElement {
    jsxCode: string;
    pfImports: string[];
    reactImports: string[];
    requiredCode?: string[];
    ref: InputReference;
    stateCode: string;
    isReadonly: boolean;
}
export declare class FormInput extends AbstractFormElement {
}
export declare class InputsContainer extends AbstractFormElement {
    childRefs: InputReference[];
}
export interface InputReference {
    binding: string;
    dataType: DataType;
    stateName: string;
    stateSetter: string;
}
export interface DataType {
    name: string;
    defaultValue?: string;
}
export {};
//# sourceMappingURL=types.d.ts.map