import * as React from "react";
declare module "react-table" {
    interface TableState {
        columnResizing: {
            isResizingColumn: boolean;
            columnWidths: {
                [columnName: string]: number;
            };
        };
    }
    interface ColumnInstance<D extends object> {
        placeholderOf?: ColumnInstance<D> | undefined;
        columns?: Array<ColumnInstance<D>>;
    }
    interface ColumnInterface<D extends object> {
        originalId?: string;
        accessor: string;
        groupType?: string;
        cssClasses?: string;
        label: string;
        headerCellElement?: JSX.Element;
        isInlineEditable?: boolean;
        dataType?: string;
        isRowIndexColumn: boolean;
        cellDelegate?: (id: string) => React.ReactNode;
        width?: number;
        setWidth?: (newWidth: number) => void;
        isWidthPinned?: boolean;
        isWidthConstant?: boolean;
        columns?: Array<Column<D>>;
    }
}
//# sourceMappingURL=react-tables.d.ts.map