import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import TestScenarioDrawerDataSelectorPanel from "./TestScenarioDrawerDataSelectorPanel";
import TestScenarioDrawerCheatSheetPanel from "./TestScenarioDrawerCheatSheetPanel";
import TestScenarioDrawerSettingsPanel from "../drawer/TestScenarioDrawerSettingsPanel";
import { TestScenarioEditorDock, TestScenarioType, } from "../TestScenarioEditor";
import { useTestScenarioEditorI18n } from "../i18n";
function TestScenarioDrawerPanel({ dataObjects, fileName, onDrawerClose, onUpdateSettingField, scesimModel, selectedColumnMetaData, selectedDock, testScenarioSettings, updateSelectedColumnMetaData, updateTestScenarioModel, }) {
    const { i18n } = useTestScenarioEditorI18n();
    return (_jsxs(DrawerPanelContent, Object.assign({ isResizable: true, minSize: "400px", defaultSize: "500px" }, { children: [_jsxs(DrawerHead, { children: [_jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClose: onDrawerClose }) }), _jsx(TextContent, { children: _jsx(Text, Object.assign({ component: TextVariants.h2 }, { children: (() => {
                                switch (selectedDock) {
                                    case TestScenarioEditorDock.CHEATSHEET:
                                        return i18n.drawer.cheatSheet.title;
                                    case TestScenarioEditorDock.DATA_OBJECT:
                                        return testScenarioSettings.assetType === TestScenarioType[TestScenarioType.DMN]
                                            ? i18n.drawer.dataSelector.titleDMN
                                            : i18n.drawer.dataSelector.titleRule;
                                    case TestScenarioEditorDock.SETTINGS:
                                        return i18n.drawer.settings.title;
                                    default:
                                        throw new Error("Wrong state, an invalid dock has been selected " + selectedDock);
                                }
                            })() })) }), _jsx(Divider, {})] }), _jsx(DrawerPanelBody, { children: (() => {
                    switch (selectedDock) {
                        case TestScenarioEditorDock.CHEATSHEET:
                            return _jsx(TestScenarioDrawerCheatSheetPanel, { assetType: testScenarioSettings.assetType });
                        case TestScenarioEditorDock.DATA_OBJECT:
                            return (_jsx(TestScenarioDrawerDataSelectorPanel, { assetType: testScenarioSettings.assetType, dataObjects: dataObjects, scesimModel: scesimModel, selectedColumnMetadata: selectedColumnMetaData, updateSelectedColumnMetaData: updateSelectedColumnMetaData, updateTestScenarioModel: updateTestScenarioModel }));
                        case TestScenarioEditorDock.SETTINGS:
                            return (_jsx(TestScenarioDrawerSettingsPanel, { fileName: fileName, onUpdateSettingField: onUpdateSettingField, testScenarioSettings: testScenarioSettings }));
                        default:
                            throw new Error("Wrong state, an invalid dock has been selected " + selectedDock);
                    }
                })() })] })));
}
export default TestScenarioDrawerPanel;
//# sourceMappingURL=TestScenarioDrawerPanel.js.map