import { CodeFragment, CodeGenElement, FormElement, FormInput } from "../../api";
import { CompiledTemplate } from "underscore";
export interface CodeGenTemplate<Element extends CodeGenElement, Properties> {
    render: (props: Properties) => Element;
}
export interface FormElementTemplateProps<Type> {
    id: string;
    name: string;
    label: string;
    disabled: boolean;
    value: Type;
}
export interface FormElementTemplate<Element extends FormElement<any>, Properties extends FormElementTemplateProps<any>> {
    render: (props: Properties) => Element;
}
export declare const FORM_GROUP_TEMPLATE: CompiledTemplate;
export declare abstract class AbstractFormGroupInputTemplate<Properties extends FormElementTemplateProps<any>> implements FormElementTemplate<FormInput, Properties> {
    readonly inputTemplate: CompiledTemplate;
    readonly setValueFromModelTemplate: CompiledTemplate;
    readonly writeValueToModelTemplate: CompiledTemplate;
    protected constructor(inputTemplate: CompiledTemplate, setValueFromModelTemplate: CompiledTemplate, writeValueToModelTemplate: CompiledTemplate);
    render(props: Properties): FormInput;
    protected buildSetValueFromModelCode(props: Properties): CodeFragment;
    protected writeValueToModelCode(props: Properties): CodeFragment | undefined;
}
//# sourceMappingURL=types.d.ts.map