"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.upgrade14to15 = exports.upgrade13to14 = exports.upgrade12to13 = exports.upgrade11to12 = exports.upgrade10to11 = exports.getMarshallerForFixedVersion = exports.getDmnVersion = exports.getKieExtensionVersion = exports.getMarshaller = exports.DMN_LATEST_VERSION = exports.DMN_VERSIONS_TIMELINE = exports.FEEL_NAMESPACES = exports.DMN_PARSERS = void 0;
var xml_parser_ts_1 = require("@kie-tools/xml-parser-ts");
var ns_1 = require("@kie-tools/xml-parser-ts/dist/ns");
var meta_1 = require("./schemas/dmn-1_0/ts-gen/meta");
var meta_2 = require("./schemas/dmn-1_1/ts-gen/meta");
var meta_3 = require("./schemas/dmn-1_2/ts-gen/meta");
var meta_4 = require("./schemas/dmn-1_3/ts-gen/meta");
var meta_5 = require("./schemas/dmn-1_4/ts-gen/meta");
var meta_6 = require("./schemas/dmn-1_5/ts-gen/meta");
var meta_7 = require("./schemas/kie-1_0/ts-gen/meta");
var kie_extensions_1 = require("./kie-extensions");
require("./kie-extensions");
exports.DMN_PARSERS = {
    "1.0": (0, xml_parser_ts_1.getParser)({
        ns: meta_1.ns,
        meta: meta_1.meta,
        subs: meta_1.subs,
        elements: meta_1.elements,
        root: meta_1.root,
    }),
    "1.1": (0, xml_parser_ts_1.getParser)({
        ns: meta_2.ns,
        meta: meta_2.meta,
        subs: meta_2.subs,
        elements: meta_2.elements,
        root: meta_2.root,
    }),
    "1.2": (0, xml_parser_ts_1.getParser)({
        ns: meta_3.ns,
        meta: meta_3.meta,
        subs: meta_3.subs,
        elements: meta_3.elements,
        root: meta_3.root,
    }),
    "1.3": (0, xml_parser_ts_1.getParser)({
        ns: meta_4.ns,
        meta: meta_4.meta,
        subs: meta_4.subs,
        elements: meta_4.elements,
        root: meta_4.root,
    }),
    "1.4": (0, xml_parser_ts_1.getParser)({
        ns: meta_5.ns,
        meta: meta_5.meta,
        subs: meta_5.subs,
        elements: meta_5.elements,
        root: meta_5.root,
    }),
    "1.5": (0, xml_parser_ts_1.getParser)({
        ns: meta_6.ns,
        meta: meta_6.meta,
        subs: meta_6.subs,
        elements: meta_6.elements,
        root: meta_6.root,
    }),
};
exports.FEEL_NAMESPACES = {
    "1.0": "http://www.omg.org/spec/FEEL/20140401",
    "1.1": "http://www.omg.org/spec/FEEL/20140401",
    "1.2": "http://www.omg.org/spec/DMN/20180521/FEEL/",
    "1.3": "https://www.omg.org/spec/DMN/20191111/FEEL/",
    "1.4": "https://www.omg.org/spec/DMN/20211108/FEEL/",
    "1.5": "https://www.omg.org/spec/DMN/20230324/FEEL/",
};
exports.DMN_VERSIONS_TIMELINE = ["1.0", "1.1", "1.2", "1.3", "1.4", "1.5"];
exports.DMN_LATEST_VERSION = "1.5";
function getMarshaller(xml, opts) {
    var _a, _b, _c, _d;
    var originalDomdoc = xml_parser_ts_1.domParser.getDomDocument(xml);
    var originalInstanceNs = (0, xml_parser_ts_1.getInstanceNs)(originalDomdoc);
    var originalMarshaller = getMarshallerForFixedVersion(originalDomdoc, originalInstanceNs);
    var targetVersion = (opts === null || opts === void 0 ? void 0 : opts.upgradeTo) === "latest" ? exports.DMN_LATEST_VERSION : (_a = opts === null || opts === void 0 ? void 0 : opts.upgradeTo) !== null && _a !== void 0 ? _a : originalMarshaller.version;
    if (originalMarshaller.version === targetVersion) {
        return __assign(__assign({}, originalMarshaller), { originalVersion: originalMarshaller.version, isLatest: true });
    }
    if (exports.DMN_VERSIONS_TIMELINE.indexOf(originalMarshaller.version) > exports.DMN_VERSIONS_TIMELINE.indexOf(targetVersion)) {
        throw new Error("DMN MARSHALLER: Cannot build DMN ".concat(targetVersion, " marshaller from a model that's already in version '").concat(originalMarshaller.version, "'. Downgrading DMN models is not possible."));
    }
    var dmn10 = undefined;
    var dmn11 = undefined;
    var dmn12 = undefined;
    var dmn13 = undefined;
    var dmn14 = undefined;
    var dmn15 = undefined;
    switch (originalMarshaller.version) {
        case "1.0":
            dmn10 = dmn10 !== null && dmn10 !== void 0 ? dmn10 : originalMarshaller.parser.parse();
            dmn11 = upgrade10to11(dmn10);
            if (targetVersion === "1.1")
                break;
        case "1.1":
            dmn11 = dmn11 !== null && dmn11 !== void 0 ? dmn11 : originalMarshaller.parser.parse();
            dmn12 = upgrade11to12(dmn11);
            if (targetVersion === "1.2")
                break;
        case "1.2":
            dmn12 = dmn12 !== null && dmn12 !== void 0 ? dmn12 : originalMarshaller.parser.parse();
            dmn13 = upgrade12to13(dmn12);
            if (targetVersion === "1.3")
                break;
        case "1.3":
            dmn13 = dmn13 !== null && dmn13 !== void 0 ? dmn13 : originalMarshaller.parser.parse();
            dmn14 = upgrade13to14(dmn13);
            if (targetVersion === "1.4")
                break;
        case "1.4":
            dmn14 = dmn14 !== null && dmn14 !== void 0 ? dmn14 : originalMarshaller.parser.parse();
            dmn15 = upgrade14to15(dmn14);
            if (targetVersion === "1.5")
                break;
        case "1.5":
            throw new Error("DMN MARSHALLER: Unexpected error. Shouldn't ever try to migrate a DMN 1.5, as DMN 1.5 is latest.");
    }
    var upgradedJson = (_d = (_c = (_b = dmn15 !== null && dmn15 !== void 0 ? dmn15 : dmn14) !== null && _b !== void 0 ? _b : dmn13) !== null && _c !== void 0 ? _c : dmn12) !== null && _d !== void 0 ? _d : dmn11;
    if (!upgradedJson) {
        throw new Error("DMN MARSHALLER: Unexpected error. At least one upgraded model should've been created.");
    }
    var parserForUpgradedJson = exports.DMN_PARSERS[targetVersion];
    if (!parserForUpgradedJson) {
        throw new Error("DMN MARSHALLER: Unexpected error. Couldn't find parser for version '".concat(targetVersion, "'."));
    }
    var upgradedInstanceNs = (0, xml_parser_ts_1.getInstanceNsFromJson)(upgradedJson.definitions);
    var upgradedXml = parserForUpgradedJson.build({ json: upgradedJson, instanceNs: upgradedInstanceNs });
    var upgradedMarshaller = getMarshallerForFixedVersion(xml_parser_ts_1.domParser.getDomDocument(upgradedXml), upgradedInstanceNs);
    return __assign(__assign({}, upgradedMarshaller), { originalVersion: originalMarshaller.version, isLatest: targetVersion === exports.DMN_LATEST_VERSION });
}
exports.getMarshaller = getMarshaller;
function getKieExtensionVersion(instanceNs) {
    if (instanceNs.get(kie_extensions_1.LEGACY_KIE_NS__PRE_GWT_REMOVAL) !== undefined) {
        return "0.0";
    }
    else if (instanceNs.get(meta_7.ns.get("")) !== undefined) {
        return "1.0";
    }
    else {
        throw new Error("DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '".concat(JSON.stringify(__spreadArray([], __read(instanceNs.entries()), false)), "'."));
    }
}
exports.getKieExtensionVersion = getKieExtensionVersion;
function getDmnVersion(instanceNs) {
    if (instanceNs.get(meta_1.ns.get("")) !== undefined) {
        return "1.0";
    }
    else if (instanceNs.get(meta_2.ns.get("")) !== undefined) {
        return "1.1";
    }
    else if (instanceNs.get(meta_3.ns.get("")) !== undefined) {
        return "1.2";
    }
    else if (instanceNs.get(meta_4.ns.get("")) !== undefined) {
        return "1.3";
    }
    else if (instanceNs.get(meta_5.ns.get("")) !== undefined) {
        return "1.4";
    }
    else if (instanceNs.get(meta_6.ns.get("")) !== undefined) {
        return "1.5";
    }
    else {
        throw new Error("DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '".concat(JSON.stringify(__spreadArray([], __read(instanceNs.entries()), false)), "'."));
    }
}
exports.getDmnVersion = getDmnVersion;
function getMarshallerForFixedVersion(domdoc, instanceNs) {
    var version = getDmnVersion(instanceNs);
    switch (version) {
        case "1.0":
            return {
                instanceNs: instanceNs,
                version: "1.0",
                root: meta_1.root,
                meta: meta_1.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.0"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.0"].build({ json: json, instanceNs: instanceNs }); } },
            };
        case "1.1":
            return {
                instanceNs: instanceNs,
                version: "1.1",
                root: meta_2.root,
                meta: meta_2.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.1"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.1"].build({ json: json, instanceNs: instanceNs }); } },
            };
        case "1.2":
            return {
                instanceNs: instanceNs,
                version: "1.2",
                root: meta_3.root,
                meta: meta_3.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.2"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.2"].build({ json: json, instanceNs: instanceNs }); } },
            };
        case "1.3":
            return {
                instanceNs: instanceNs,
                version: "1.3",
                root: meta_4.root,
                meta: meta_4.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.3"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.3"].build({ json: json, instanceNs: instanceNs }); } },
            };
        case "1.4":
            return {
                instanceNs: instanceNs,
                version: "1.4",
                root: meta_5.root,
                meta: meta_5.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.4"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.4"].build({ json: json, instanceNs: instanceNs }); } },
            };
        case "1.5":
            return {
                instanceNs: instanceNs,
                version: "1.5",
                root: meta_6.root,
                meta: meta_6.meta,
                parser: { parse: function () { return exports.DMN_PARSERS["1.5"].parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
                builder: { build: function (json) { return exports.DMN_PARSERS["1.5"].build({ json: json, instanceNs: instanceNs }); } },
            };
        default:
            throw new Error("DMN MARSHALLER: Unknown version declared for DMN. Instance NS --> '".concat(JSON.stringify(__spreadArray([], __read(instanceNs.entries()), false)), "'."));
    }
}
exports.getMarshallerForFixedVersion = getMarshallerForFixedVersion;
var kieLegacyNs = new Map([
    ["kie:", kie_extensions_1.LEGACY_KIE_NS__PRE_GWT_REMOVAL],
    [kie_extensions_1.LEGACY_KIE_NS__PRE_GWT_REMOVAL, "kie:"],
]);
function upgrade10to11(dmn10) {
    throw new Error("DMN MARSHALLER: Upgrading from DMN 1.0 is not supported. Minimum version is 1.2.");
}
exports.upgrade10to11 = upgrade10to11;
function upgrade11to12(dmn11) {
    throw new Error("DMN MARSHALLER: Upgrading from DMN 1.1 is not supported. Minimum version is 1.2.");
}
exports.upgrade11to12 = upgrade11to12;
function upgrade12to13(dmn12) {
    var instanceNs = (0, xml_parser_ts_1.getInstanceNsFromJson)(dmn12.definitions);
    dmn12.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_3.ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_3.ns,
    })] = meta_4.ns.get("");
    dmn12.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_3.ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_3.ns,
    })] = meta_4.ns.get("dmndi:");
    dmn12.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: kie_extensions_1.LEGACY_KIE_NS__PRE_GWT_REMOVAL,
        atInstanceNs: instanceNs,
        fallingBackToNs: kieLegacyNs,
    })] = meta_7.ns.get("");
    if (dmn12.definitions["@_typeLanguage"] === exports.FEEL_NAMESPACES["1.2"]) {
        dmn12.definitions["@_typeLanguage"] = exports.FEEL_NAMESPACES["1.3"];
    }
    if (dmn12.definitions["@_expressionLanguage"] === exports.FEEL_NAMESPACES["1.2"]) {
        dmn12.definitions["@_expressionLanguage"] = exports.FEEL_NAMESPACES["1.3"];
    }
    return dmn12;
}
exports.upgrade12to13 = upgrade12to13;
function upgrade13to14(dmn13) {
    var instanceNs = (0, xml_parser_ts_1.getInstanceNsFromJson)(dmn13.definitions);
    dmn13.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_4.ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_4.ns,
    })] = meta_5.ns.get("");
    dmn13.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_4.ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_4.ns,
    })] = meta_5.ns.get("dmndi:");
    if (dmn13.definitions["@_typeLanguage"] === exports.FEEL_NAMESPACES["1.3"]) {
        dmn13.definitions["@_typeLanguage"] = exports.FEEL_NAMESPACES["1.4"];
    }
    if (dmn13.definitions["@_expressionLanguage"] === exports.FEEL_NAMESPACES["1.3"]) {
        dmn13.definitions["@_expressionLanguage"] = exports.FEEL_NAMESPACES["1.4"];
    }
    return dmn13;
}
exports.upgrade13to14 = upgrade13to14;
function upgrade14to15(dmn14) {
    var instanceNs = (0, xml_parser_ts_1.getInstanceNsFromJson)(dmn14.definitions);
    dmn14.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_5.ns.get(""),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_5.ns,
    })] = meta_6.ns.get("");
    dmn14.definitions[(0, ns_1.getNsDeclarationPropName)({
        namespace: meta_5.ns.get("dmndi:"),
        atInstanceNs: instanceNs,
        fallingBackToNs: meta_5.ns,
    })] = meta_6.ns.get("dmndi:");
    if (dmn14.definitions["@_typeLanguage"] === exports.FEEL_NAMESPACES["1.4"]) {
        dmn14.definitions["@_typeLanguage"] = exports.FEEL_NAMESPACES["1.5"];
    }
    if (dmn14.definitions["@_expressionLanguage"] === exports.FEEL_NAMESPACES["1.4"]) {
        dmn14.definitions["@_expressionLanguage"] = exports.FEEL_NAMESPACES["1.5"];
    }
    return dmn14;
}
exports.upgrade14to15 = upgrade14to15;
//# sourceMappingURL=index.js.map