import React, { useImperativeHandle, useState } from "react";
import WorkflowDefinitionList from "./components/WorkflowDefinitionList/WorkflowDefinitionList";
import WorkflowDefinitionListEnvelopeViewDriver from "./WorkflowDefinitionListEnvelopeViewDriver";
export const WorkflowDefinitionListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(WorkflowDefinitionList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new WorkflowDefinitionListEnvelopeViewDriver(props.channelApi) })));
});
export default WorkflowDefinitionListEnvelopeView;
//# sourceMappingURL=WorkflowDefinitionListEnvelopeView.js.map