var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState } from "react";
import { DropdownItem, Dropdown, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { handleJobRescheduleUtil, jobCancel } from "../../../utils/Utils";
import { JobsDetailsModal } from "../../../../jobsManagement/envelope/components/JobsDetailsModal";
import { JobsRescheduleModal } from "../../../../jobsManagement/envelope/components/JobsRescheduleModal";
import { JobsCancelModal } from "../../../../jobsManagement/envelope/components/JobsCancelModal";
const JobActionsKebab = ({ job, driver, ouiaId, ouiaSafe }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [rescheduleError, setRescheduleError] = useState("");
    const [isCancelModalOpen, setIsCancelModalOpen] = useState(false);
    const [isRescheduleModalOpen, setIsRescheduleModalOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState();
    const [modalContent, setModalContent] = useState("");
    const RescheduleJobs = ["SCHEDULED", "ERROR"];
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const handleCancelModalToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
    };
    const onSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const onDetailsClick = () => {
        handleModalToggle();
    };
    const handleRescheduleAction = () => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
    };
    const handleJobReschedule = (_job, repeatInterval, repeatLimit, scheduleDate) => __awaiter(void 0, void 0, void 0, function* () {
        yield handleJobRescheduleUtil(repeatInterval, repeatLimit, scheduleDate, job, handleRescheduleAction, driver, setRescheduleError);
    });
    const handleCancelAction = () => __awaiter(void 0, void 0, void 0, function* () {
        yield jobCancel(driver, job, setModalTitle, setModalContent);
        handleCancelModalToggle();
    });
    const rescheduleActions = [
        React.createElement(Button, { key: "cancel-reschedule", variant: "secondary", onClick: handleRescheduleAction }, "Cancel"),
    ];
    const detailsAction = [
        React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: handleModalToggle }, "OK"),
    ];
    const dropdownItems = () => {
        if (job.endpoint !== null && RescheduleJobs.includes(job.status)) {
            return [
                React.createElement(DropdownItem, { "data-testid": "job-details", key: "details", component: "button", onClick: onDetailsClick }, "Details"),
                React.createElement(DropdownItem, { "data-testid": "job-reschedule", key: "reschedule", component: "button", id: "reschedule-option", onClick: handleRescheduleAction }, "Reschedule"),
                React.createElement(DropdownItem, { "data-testid": "job-cancel", key: "cancel", component: "button", id: "cancel-option", onClick: handleCancelAction }, "Cancel"),
            ];
        }
        else {
            return [
                React.createElement(DropdownItem, { "data-testid": "job-details", key: "details", component: "button", onClick: onDetailsClick }, "Details"),
            ];
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(JobsDetailsModal, { actionType: "Job Details", modalTitle: setTitle("success", "Job Details"), isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalAction: detailsAction, job: job }),
        React.createElement(JobsRescheduleModal, { actionType: "Job Reschedule", isModalOpen: isRescheduleModalOpen, handleModalToggle: handleRescheduleAction, modalAction: rescheduleActions, job: job, rescheduleError: rescheduleError, setRescheduleError: setRescheduleError, handleJobReschedule: handleJobReschedule }),
        React.createElement(JobsCancelModal, { actionType: "Job Cancel", isModalOpen: isCancelModalOpen, handleModalToggle: handleCancelModalToggle, modalTitle: modalTitle, modalContent: modalContent }),
        React.createElement(Dropdown, Object.assign({ onSelect: onSelect, toggle: React.createElement(KebabToggle, { onToggle: onToggle, id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "Job actions dropdown", "aria-labelledby": "Job actions dropdown", dropdownItems: dropdownItems() }, componentOuiaProps(ouiaId, "job-actions-kebab", ouiaSafe)))));
};
export default JobActionsKebab;
//# sourceMappingURL=JobActionsKebab.js.map