var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useCallback, useEffect, useMemo, useState } from "react";
import { EmbeddedEditor, EmbeddedEditorChannelApiImpl } from "@kie-tools-core/editor/dist/embedded";
import { ChannelType, EditorEnvelopeLocator, EnvelopeContentType, EnvelopeMapping, } from "@kie-tools-core/editor/dist/api";
import { Card, CardHeader, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { StateControl } from "@kie-tools-core/editor/dist/channel";
import { SwfCombinedEditorChannelApiImpl, SwfPreviewOptionsChannelApiImpl, } from "@kie-tools/serverless-workflow-combined-editor/dist/channel";
import { useController } from "../../../hooks/useController";
const SwfCombinedEditor = ({ workflowInstance, width, height, ouiaId, ouiaSafe, }) => {
    const { source, nodes, error } = workflowInstance;
    const [editor, editorRef] = useController();
    const [isReady, setReady] = useState(false);
    const getFileContent = useCallback(() => {
        if (!source) {
            return;
        }
        const arr = new Uint8Array(source.length);
        for (let i = 0; i < source.length; i++) {
            arr[i] = source.charCodeAt(i);
        }
        const decoder = new TextDecoder("utf-8");
        return decoder.decode(arr);
    }, [source]);
    const getFileType = useCallback(() => {
        const source = getFileContent();
        if (!source) {
            return;
        }
        if (source.trim().charAt(0) === "{") {
            return "json";
        }
        else {
            return "yaml";
        }
    }, [source]);
    const embeddedFile = useMemo(() => {
        return {
            normalizedPosixPathRelativeToTheWorkspaceRoot: `workflow.sw.${getFileType()}`,
            getFileContents: () => __awaiter(void 0, void 0, void 0, function* () { return Promise.resolve(getFileContent()); }),
            isReadOnly: true,
            fileExtension: `sw.${getFileType()}`,
            fileName: `workflow.sw.${getFileType()}`,
            path: `*.sw.${getFileType()}`,
        };
    }, [source]);
    const stateControl = useMemo(() => new StateControl(), [embeddedFile === null || embeddedFile === void 0 ? void 0 : embeddedFile.getFileContents]);
    const editorEnvelopeLocator = useMemo(() => new EditorEnvelopeLocator(window.location.origin, [
        new EnvelopeMapping({
            type: "swf",
            filePathGlob: "**/*.sw.+(json|yml|yaml)",
            resourcesPathPrefix: ".",
            envelopeContent: {
                type: EnvelopeContentType.PATH,
                path: "serverless-workflow-combined-editor-envelope.html",
            },
        }),
    ]), [source]);
    const channelApiImpl = useMemo(() => new EmbeddedEditorChannelApiImpl(stateControl, embeddedFile, "en", {
        kogitoEditor_ready: () => {
            setReady(true);
        },
    }), [stateControl, embeddedFile]);
    const swfPreviewOptionsChannelApiImpl = useMemo(() => new SwfPreviewOptionsChannelApiImpl({
        defaultWidth: "100%",
    }), []);
    const apiImpl = useMemo(() => new SwfCombinedEditorChannelApiImpl({
        defaultApiImpl: channelApiImpl,
        swfPreviewOptionsChannelApiImpl: swfPreviewOptionsChannelApiImpl,
    }), [channelApiImpl, swfPreviewOptionsChannelApiImpl]);
    useEffect(() => {
        const combinedEditorChannelApi = embeddedFile
            ? editor === null || editor === void 0 ? void 0 : editor.getEnvelopeServer().envelopeApi
            : undefined;
        const combinedEditorEnvelopeApi = embeddedFile
            ? editor === null || editor === void 0 ? void 0 : editor.getEnvelopeServer().envelopeApi
            : undefined;
        const nodeNames = [];
        nodes.forEach((node) => {
            nodeNames.push(node.name);
        });
        const colorConnectedEnds = nodeNames.includes("End");
        const isStartNodeAvailable = nodeNames.includes("Start");
        if (!isStartNodeAvailable) {
            nodeNames.push("Start");
        }
        if (combinedEditorEnvelopeApi && combinedEditorChannelApi) {
            let errorNode = undefined;
            if (error) {
                errorNode = nodes.filter((node) => node.nodeId === error.nodeDefinitionId)[0];
                combinedEditorChannelApi.notifications.kogitoSwfCombinedEditor_combinedEditorReady.subscribe(() => {
                    combinedEditorEnvelopeApi.notifications.kogitoSwfCombinedEditor_colorNodes.send({
                        nodeNames: [errorNode.name],
                        color: "#f4d5d5",
                        colorConnectedEnds,
                    });
                });
            }
            const successNodes = errorNode ? nodeNames.filter((nodeName) => nodeName !== (errorNode === null || errorNode === void 0 ? void 0 : errorNode.name)) : nodeNames;
            combinedEditorChannelApi.notifications.kogitoSwfCombinedEditor_combinedEditorReady.subscribe(() => {
                combinedEditorEnvelopeApi.notifications.kogitoSwfCombinedEditor_colorNodes.send({
                    nodeNames: successNodes,
                    color: "#d5f4e6",
                    colorConnectedEnds,
                });
            });
        }
    }, [editor, nodes, embeddedFile]);
    return (React.createElement(Card, Object.assign({ style: { height: height, width: width } }, componentOuiaProps(ouiaId, "swf-diagram", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Serverless Workflow Diagram")),
        React.createElement(CardBody, null,
            React.createElement(EmbeddedEditor, { customChannelApiImpl: apiImpl, isReady: isReady, file: embeddedFile, channelType: ChannelType.ONLINE_MULTI_FILE, editorEnvelopeLocator: editorEnvelopeLocator, locale: "en", stateControl: stateControl, ref: editorRef }))));
};
export default SwfCombinedEditor;
//# sourceMappingURL=SwfCombinedEditor.js.map