import Moment from "react-moment";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import React from "react";
import { LevelDownAltIcon } from "@patternfly/react-icons/dist/js/icons/level-down-alt-icon";
import { LevelUpAltIcon } from "@patternfly/react-icons/dist/js/icons/level-up-alt-icon";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { WorkflowInstanceIconCreator, getWorkflowInstanceDescription } from "../../../utils/Utils";
const WorkflowDetailsPanel = ({ workflowInstance, driver, ouiaId, ouiaSafe }) => {
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId ? ouiaId : workflowInstance.id, "workflow-details", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Details")),
        React.createElement(CardBody, null,
            React.createElement(Form, null,
                React.createElement(FormGroup, { label: "Name", fieldId: "name" },
                    React.createElement(Text, { component: TextVariants.p }, workflowInstance.processName)),
                workflowInstance.businessKey && (React.createElement(FormGroup, { label: "Business key", fieldId: "businessKey" },
                    React.createElement(Text, { component: TextVariants.p }, workflowInstance.businessKey))),
                React.createElement(FormGroup, { label: "State", fieldId: "state" },
                    React.createElement(Text, { component: TextVariants.p }, WorkflowInstanceIconCreator(workflowInstance.state))),
                React.createElement(FormGroup, { label: "Id", fieldId: "id" },
                    React.createElement(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak" }, workflowInstance.id)),
                workflowInstance.serviceUrl ? (React.createElement(FormGroup, { label: "Endpoint", fieldId: "endpoint" },
                    React.createElement(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak" },
                        React.createElement(EndpointLink, { serviceUrl: workflowInstance.serviceUrl, isLinkShown: true })))) : (""),
                React.createElement(FormGroup, { label: "Start", fieldId: "start" }, workflowInstance.start ? (React.createElement(Text, { component: TextVariants.p },
                    React.createElement(Moment, { fromNow: true }, new Date(`${workflowInstance.start}`)))) : ("")),
                workflowInstance.lastUpdate && (React.createElement(FormGroup, { label: "Last Updated", fieldId: "lastUpdate" },
                    React.createElement(Text, { component: TextVariants.p },
                        React.createElement(Moment, { fromNow: true }, new Date(`${workflowInstance.lastUpdate}`))))),
                workflowInstance.end && (React.createElement(FormGroup, { label: "End", fieldId: "end" },
                    React.createElement(Text, { component: TextVariants.p },
                        React.createElement(Moment, { fromNow: true }, new Date(`${workflowInstance.end}`))))),
                workflowInstance.parentWorkflowInstance && (React.createElement(FormGroup, { label: "Parent Workflow", fieldId: "parent" },
                    React.createElement("div", null,
                        React.createElement(Button, Object.assign({ "data-testid": "open-parent-workflow", variant: "link", icon: React.createElement(LevelUpAltIcon, null), onClick: () => {
                                driver.openWorkflowInstanceDetails(workflowInstance.parentWorkflowInstance.id);
                            } }, componentOuiaProps(ouiaId ? ouiaId : workflowInstance.parentWorkflowInstance.id, "workflow-details", ouiaSafe)),
                            React.createElement(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(workflowInstance.parentWorkflowInstance) }))))),
                workflowInstance.childWorkflowInstances && workflowInstance.childWorkflowInstances.length !== 0 && (React.createElement(FormGroup, { label: "Sub Workflows", fieldId: "child" }, workflowInstance.childWorkflowInstances.map((child) => (React.createElement("div", { key: child.id },
                    React.createElement(Button, Object.assign({ variant: "link", icon: React.createElement(LevelDownAltIcon, null), onClick: () => {
                            driver.openWorkflowInstanceDetails(child.id);
                        } }, componentOuiaProps(ouiaId ? ouiaId : child.id, "workflow-details", ouiaSafe)),
                        React.createElement(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(child) })))))))))));
};
export default WorkflowDetailsPanel;
//# sourceMappingURL=WorkflowDetailsPanel.js.map