import React, { useCallback, useEffect, useImperativeHandle, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import WorkflowForm from "./components/WorkflowForm/WorkflowForm";
import CustomWorkflowForm from "./components/CustomWorkflowForm/CustomWorkflowForm";
import { WorkflowFormEnvelopeViewDriver } from "./WorkflowFormEnvelopeViewDriver";
export const WorkflowFormEnvelopeView = React.forwardRef(({ channelApi, ouiaId }, forwardedRef) => {
    const [workflowDefinition, setWorkflowDefinition] = useState({});
    const [isLoading, setIsLoading] = useState(true);
    const [driver] = useState(new WorkflowFormEnvelopeViewDriver(channelApi));
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [workflowSchema, setWorkflowSchema] = useState();
    useImperativeHandle(forwardedRef, () => ({
        initialize: (workflowDefinitionData) => {
            setEnvelopeConnectedToChannel(true);
            setWorkflowDefinition(workflowDefinitionData);
        },
    }), []);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            getCustomForm();
        }
    }, [isEnvelopeConnectedToChannel]);
    const getCustomForm = useCallback(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
        }
        driver
            .getCustomWorkflowSchema()
            .then((schema) => {
            setWorkflowSchema(schema);
        })
            .finally(() => {
            setIsLoading(false);
        });
    }, [isEnvelopeConnectedToChannel]);
    if (isLoading) {
        return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "workflow-form-envelope-view") + "-loading-spinner", "workflow-form", true)),
            React.createElement(KogitoSpinner, { spinnerText: `Loading workflow form...` })));
    }
    if (workflowSchema && workflowSchema.properties && Object.keys(workflowSchema.properties).length > 0) {
        return (React.createElement(CustomWorkflowForm, { customFormSchema: workflowSchema, driver: driver, workflowDefinition: workflowDefinition }));
    }
    return React.createElement(WorkflowForm, { workflowDefinition: workflowDefinition, driver: driver });
});
export default WorkflowFormEnvelopeView;
//# sourceMappingURL=WorkflowFormEnvelopeView.js.map