import React, { useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ActionType } from "@kie-tools/runtime-tools-components/dist/utils";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { FormRenderer } from "@kie-tools/runtime-tools-components/dist/components/FormRenderer";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const CustomWorkflowForm = ({ workflowDefinition, customFormSchema, driver, ouiaId, ouiaSafe, }) => {
    const formRendererApi = React.useRef(null);
    const [isLoading, setIsLoading] = useState(false);
    const formAction = [
        {
            name: "Start",
        },
        {
            name: "Reset",
            execute: () => {
                var _a;
                (_a = formRendererApi === null || formRendererApi === void 0 ? void 0 : formRendererApi.current) === null || _a === void 0 ? void 0 : _a.doReset();
            },
            actionType: ActionType.RESET,
        },
    ];
    const startWorkflow = (data) => {
        setIsLoading(true);
        driver
            .startWorkflow(workflowDefinition.endpoint, data)
            .then(() => {
            var _a;
            (_a = formRendererApi === null || formRendererApi === void 0 ? void 0 : formRendererApi.current) === null || _a === void 0 ? void 0 : _a.doReset();
        })
            .finally(() => {
            setIsLoading(false);
        });
    };
    if (isLoading) {
        return (React.createElement(Bullseye, null,
            React.createElement(KogitoSpinner, { spinnerText: "Starting workflow...", ouiaId: "custom-workflow-form-loading" })));
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "custom-workflow-form", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(FormRenderer, { formSchema: customFormSchema, readOnly: false, onSubmit: startWorkflow, formActions: formAction, ref: formRendererApi })));
};
export default CustomWorkflowForm;
//# sourceMappingURL=CustomWorkflowForm.js.map