var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useCallback, useMemo, useRef, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ActionGroup, Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { ValidatedOptions } from "@patternfly/react-core/dist/js/helpers";
import HelpIcon from "@patternfly/react-icons/dist/esm/icons/help-icon";
import ExclamationCircleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon";
import { validateWorkflowData } from "./validateWorkflowData";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { RequestDataEditor, } from "@kie-tools/runtime-tools-components/dist/components/RequestDataEditor";
const WorkflowForm = ({ workflowDefinition, driver, ouiaId, ouiaSafe }) => {
    const [data, setData] = useState("");
    const [isValid, setIsValid] = useState(true);
    const [isLoading, setIsLoading] = useState(false);
    const requestDataEditorRef = useRef(null);
    const resetForm = useCallback(() => {
        var _a;
        driver.resetBusinessKey();
        setData("");
        setIsValid(true);
        (_a = requestDataEditorRef.current) === null || _a === void 0 ? void 0 : _a.setContent("");
    }, []);
    const onSubmit = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        const valid = validateWorkflowData(data);
        setIsValid(valid);
        if (!valid) {
            return;
        }
        setIsLoading(true);
        yield driver.startWorkflow(workflowDefinition.endpoint, data.trim() ? JSON.parse(data) : {});
        setIsLoading(false);
        resetForm();
    }), [driver, data]);
    const requestDataEditor = useMemo(() => {
        return (React.createElement(RequestDataEditor, { ref: requestDataEditorRef, content: "", onContentChange: (args) => setData(args.content), isReadOnly: false }));
    }, [setData]);
    if (isLoading) {
        return (React.createElement(Bullseye, null,
            React.createElement(KogitoSpinner, { spinnerText: "Starting workflow...", ouiaId: "workflow-form-loading" })));
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "workflow-form", ouiaSafe)),
        React.createElement(Stack, { hasGutter: true },
            React.createElement(StackItem, null,
                React.createElement(Alert, { isInline: true, variant: "info", title: "Couldn't find JSON schema to display the Start Form." },
                    React.createElement("p", null,
                        "Please type the data in JSON format in the Code Editor and press the ",
                        React.createElement("b", null, "Start"),
                        " to submit it and start the Workflow."),
                    React.createElement("p", null,
                        "If you want to use a Form to start the workflow, please provide a valid JSON schema in the",
                        " ",
                        React.createElement("code", null, "dataInputSchema"),
                        " property in your workflow file."))),
            React.createElement(StackItem, null,
                React.createElement(Form, { isHorizontal: true },
                    React.createElement(FormGroup, { label: "Start Workflow Data", isRequired: true, fieldId: "workflowData", helperTextInvalid: !isValid && "The Workflow Data should have a JSON format.", helperTextInvalidIcon: React.createElement(ExclamationCircleIcon, null), validated: !isValid ? ValidatedOptions.error : ValidatedOptions.default, labelIcon: React.createElement(Popover, { id: "workflow-form-data-help", bodyContent: React.createElement("div", null, "Fill the data to start the Workflow in JSON format.") },
                            React.createElement("button", { type: "button", "aria-label": "More info for data field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help" },
                                React.createElement(HelpIcon, { noVerticalAlign: true }))) }, requestDataEditor),
                    React.createElement(ActionGroup, null,
                        React.createElement(Button, { variant: "primary", onClick: onSubmit, "data-testid": "start-button" }, "Start"),
                        React.createElement(Button, { variant: "secondary", onClick: resetForm }, "Reset")))))));
};
export default WorkflowForm;
//# sourceMappingURL=WorkflowForm.js.map