var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useCallback, useEffect, useState } from "react";
import { ExpandableRowContent } from "@patternfly/react-table/dist/js/components/Table";
import { TableComposable, Thead, Tbody, Tr, Th, Td } from "@patternfly/react-table/dist/js/components/TableComposable";
import _ from "lodash";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { WorkflowInfoModal } from "@kie-tools/runtime-tools-components/dist/components/WorkflowInfoModal";
import WorkflowListChildTable from "../WorkflowListChildTable/WorkflowListChildTable";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import { getWorkflowInstanceDescription, WorkflowInstanceIconCreator } from "../utils/WorkflowListUtils";
import WorkflowListActionsKebab from "../WorkflowListActionsKebab/WorkflowListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import "../styles.css";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const WorkflowListTable = ({ isLoading, expanded, setExpanded, sortBy, onSort, workflowInstances, setWorkflowInstances, selectedInstances, setSelectedInstances, selectableInstances, setSelectableInstances, setIsAllChecked, driver, ouiaId, ouiaSafe, }) => {
    const [rowPairs, setRowPairs] = useState([]);
    const columns = ["__Toggle", "__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const [modalTitle, setModalTitle] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [titleType, setTitleType] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [selectedWorkflowInstance, setSelectedWorkflowInstance] = useState(null);
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onShowMessage = (title, content, type, workflowInstance) => {
        setSelectedWorkflowInstance(workflowInstance);
        setTitleType(type);
        setModalTitle(title);
        setModalContent(content);
        handleModalToggle();
    };
    const onSkipClick = (workflowInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleWorkflowSkip(workflowInstance);
            onShowMessage("Skip operation", `The workflows ${workflowInstance.processName} was successfully skipped.`, TitleType.SUCCESS, workflowInstance);
        }
        catch (error) {
            onShowMessage("Skip operation", `The workflow ${workflowInstance.processName} failed to skip. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const onRetryClick = (workflowInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleWorkflowRetry(workflowInstance);
            onShowMessage("Retry operation", `The workflow ${workflowInstance.processName} was successfully re-executed.`, TitleType.SUCCESS, workflowInstance);
        }
        catch (error) {
            onShowMessage("Retry operation", `The workflow ${workflowInstance.processName} failed to re-execute. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const onAbortClick = (workflowInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleWorkflowAbort(workflowInstance);
            onShowMessage("Abort operation", `The workflow ${workflowInstance.processName} was successfully aborted.`, TitleType.SUCCESS, workflowInstance);
            workflowInstances.forEach((instance) => {
                if (instance.id === workflowInstance.id) {
                    instance.state = WorkflowInstanceState.Aborted;
                }
            });
            setWorkflowInstances([...workflowInstances]);
        }
        catch (error) {
            onShowMessage("Abort operation", `Failed to abort workflow ${workflowInstance.processName}. Message: ${error.message}`, TitleType.FAILURE, workflowInstance);
        }
        finally {
            handleModalToggle();
        }
    });
    const onOpenTriggerCloudEvent = useCallback((workflowInstance) => {
        return (instance) => driver.openTriggerCloudEvent(instance);
    }, [driver]);
    const handleClick = (workflowInstance) => {
        driver.openWorkflow(workflowInstance);
    };
    useEffect(() => {
        if (!_.isEmpty(workflowInstances)) {
            const tempRows = [];
            workflowInstances.forEach((workflowInstance) => {
                var _a;
                tempRows.push({
                    id: workflowInstance.id,
                    parent: [
                        React.createElement(React.Fragment, null, ((_a = workflowInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) && workflowInstance.serviceUrl !== null ? (React.createElement(Checkbox, { isChecked: workflowInstance.isSelected, onChange: () => checkBoxSelect(workflowInstance), "aria-label": "workflow-list-checkbox", id: `checkbox-${workflowInstance.id}`, name: `checkbox-${workflowInstance.id}` })) : (React.createElement(DisablePopup, { workflowInstanceData: workflowInstance, component: React.createElement(Checkbox, { "aria-label": "workflow-list-checkbox-disabled", id: `checkbox-${workflowInstance.id}`, isDisabled: true }) }))),
                        React.createElement(React.Fragment, null,
                            React.createElement("a", Object.assign({ className: "kogito-workflow-list__link", onClick: () => handleClick(workflowInstance) }, componentOuiaProps(ouiaId, "workflow-description", ouiaSafe)),
                                React.createElement("strong", null,
                                    React.createElement(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(workflowInstance) }))),
                            React.createElement(EndpointLink, { serviceUrl: workflowInstance.serviceUrl, isLinkShown: false })),
                        workflowInstance.state === WorkflowInstanceState.Error ? (React.createElement(ErrorPopover, { workflowInstanceData: workflowInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (WorkflowInstanceIconCreator(workflowInstance.state)),
                        workflowInstance.start ? React.createElement(Moment, { fromNow: true }, new Date(`${workflowInstance.start}`)) : "",
                        workflowInstance.lastUpdate ? (React.createElement("span", null,
                            React.createElement(HistoryIcon, { className: "pf-u-mr-sm" }),
                            " ",
                            "Updated ",
                            React.createElement(Moment, { fromNow: true }, new Date(`${workflowInstance.lastUpdate}`)))) : (""),
                        React.createElement(WorkflowListActionsKebab, { workflowInstance: workflowInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, onOpenTriggerCloudEvent: onOpenTriggerCloudEvent, key: workflowInstance.id }),
                    ],
                    child: [workflowInstance.id],
                });
            });
            setRowPairs(tempRows);
        }
        else {
            setRowPairs([]);
        }
    }, [workflowInstances]);
    const loadChild = (parentId, parentIndex) => {
        if (!expanded[parentIndex]) {
            return null;
        }
        else {
            return (React.createElement(WorkflowListChildTable, { parentWorkflowId: parentId, workflowInstances: workflowInstances, setWorkflowInstances: setWorkflowInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, setSelectableInstances: setSelectableInstances, driver: driver, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, ouiaId: parentId }));
        }
    };
    const checkBoxSelect = (workflowInstance) => {
        const clonedWorkflowInstances = [...workflowInstances];
        clonedWorkflowInstances.forEach((instance) => {
            if (workflowInstance.id === instance.id) {
                if (instance.isSelected) {
                    instance.isSelected = false;
                    setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== instance.id));
                }
                else {
                    instance.isSelected = true;
                    setSelectedInstances([...selectedInstances, instance]);
                }
            }
        });
        setWorkflowInstances(clonedWorkflowInstances);
    };
    const onToggle = (pairIndex, pair) => {
        var _a;
        setExpanded(Object.assign(Object.assign({}, expanded), { [pairIndex]: !expanded[pairIndex] }));
        if (expanded[pairIndex]) {
            const workflowInstance = workflowInstances.find((instance) => instance.id === pair.id);
            (_a = workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                if (childInstance.isSelected) {
                    const index = selectedInstances.findIndex((selectedInstance) => selectedInstance.id === childInstance.id);
                    if (index !== -1) {
                        selectedInstances.splice(index, 1);
                    }
                }
            });
            workflowInstances.forEach((instance) => {
                var _a;
                if ((workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.id) === instance.id) {
                    instance.isOpen = false;
                    (_a = instance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((child) => {
                        var _a;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                            setSelectableInstances((prev) => prev - 1);
                        }
                    });
                }
            });
        }
        else {
            const workflowInstance = !_.isEmpty(workflowInstances)
                ? workflowInstances.find((instance) => instance.id === pair.id)
                : undefined;
            !_.isEmpty(workflowInstances) &&
                workflowInstances.forEach((instance) => {
                    if ((workflowInstance === null || workflowInstance === void 0 ? void 0 : workflowInstance.id) === instance.id) {
                        instance.isOpen = true;
                    }
                });
        }
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(WorkflowInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: setTitle(titleType, modalTitle), modalContent: modalContent, workflowName: selectedWorkflowInstance === null || selectedWorkflowInstance === void 0 ? void 0 : selectedWorkflowInstance.processName, ouiaId: selectedWorkflowInstance ? "workflow-" + selectedWorkflowInstance.id : undefined }),
        React.createElement(TableComposable, Object.assign({ "aria-label": "Workflow List Table" }, componentOuiaProps(ouiaId, "workflow-list-table", ouiaSafe ? ouiaSafe : !isLoading)),
            React.createElement(Thead, null,
                React.createElement(Tr, { ouiaId: "workflow-list-table-header" }, columns.map((column, columnIndex) => {
                    let sortParams = {};
                    if (!isLoading && rowPairs.length > 0) {
                        sortParams = {
                            sort: {
                                sortBy,
                                onSort,
                                columnIndex,
                            },
                        };
                    }
                    let styleParams;
                    switch (columnIndex) {
                        case 0:
                            styleParams = { width: "72px" };
                            sortParams = {};
                            break;
                        case 1:
                            styleParams = { width: "86px" };
                            sortParams = {};
                            break;
                        case columns.length - 1:
                            styleParams = { width: "188px" };
                            sortParams = {};
                            break;
                    }
                    return (React.createElement(Th, Object.assign({ style: styleParams, key: `${column}_header` }, sortParams), column.startsWith("__") ? "" : column));
                }))),
            !isLoading && !_.isEmpty(rowPairs) ? (rowPairs.map((pair, pairIndex) => {
                const parentRow = (React.createElement(Tr, Object.assign({ key: `${pair.id}-parent` }, componentOuiaProps(pair.id, "workflow-list-row", true)),
                    React.createElement(Td, Object.assign({ key: `${pair.id}-parent-0`, expand: {
                            rowIndex: pairIndex,
                            isExpanded: expanded[pairIndex],
                            onToggle: () => onToggle(pairIndex, pair),
                        } }, componentOuiaProps(columns[0].toLowerCase(), "workflow-list-cell", true))),
                    pair.parent.map((cell, cellIndex) => (React.createElement(Td, Object.assign({ key: `${pair.id}-parent-${columns[cellIndex + 1]}`, dataLabel: columns[cellIndex + 1] }, componentOuiaProps(columns[cellIndex + 1].toLowerCase(), "workflow-list-cell", true)), cell)))));
                const childRow = (React.createElement(Tr, Object.assign({ key: `${pair.id}-child`, isExpanded: expanded[pairIndex] === true }, componentOuiaProps(pair.id, "workflow-list-row-expanded", true)),
                    React.createElement(Td, { key: `${pair.id}-child-0` }),
                    rowPairs[pairIndex].child.map((cell, cellIndex) => (React.createElement(Td, { key: `${pair.id}-child-${columns[++cellIndex]}`, dataLabel: columns[cellIndex], noPadding: rowPairs[pairIndex].noPadding, colSpan: 6 },
                        React.createElement(ExpandableRowContent, null, loadChild(cell, pairIndex)))))));
                return (React.createElement(Tbody, { key: `${pair.id}_tBody` },
                    parentRow,
                    childRow));
            })) : (React.createElement("tbody", null,
                React.createElement(Tr, null,
                    React.createElement(Td, { colSpan: 7 },
                        React.createElement(React.Fragment, null,
                            isLoading && rowPairs.length === 0 && (React.createElement(KogitoSpinner, { spinnerText: "Loading workflow instances..." })),
                            !isLoading && rowPairs.length === 0 && (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }))))))))));
};
export default WorkflowListTable;
//# sourceMappingURL=WorkflowListTable.js.map