import React, { useEffect, useState } from "react";
import { v4 as uuidv4 } from "uuid";
import { useFormDetailsContext } from "../../components/contexts/FormDetailsContext";
import { buildTestContext } from "./utils/utils";
import { EmbeddedFormDisplayer } from "../../../../formDisplayer";
const FormDisplayerContainer = ({ formContent, targetOrigin }) => {
    const [displayerKey, setDisplayerKey] = useState(uuidv4());
    const appContext = useFormDetailsContext();
    const formDisplayerApiRef = React.useRef({});
    useEffect(() => {
        const unsubscribeUserChange = appContext.onUpdateContent({
            onUpdateContent(formContent) {
                setDisplayerKey(uuidv4());
            },
        });
        return () => {
            unsubscribeUserChange.unSubscribe();
        };
    }, []);
    return (React.createElement(EmbeddedFormDisplayer, { targetOrigin: targetOrigin, envelopePath: "resources/form-displayer.html", formContent: formContent, context: buildTestContext(formContent), ref: formDisplayerApiRef, key: displayerKey }));
};
export default FormDisplayerContainer;
//# sourceMappingURL=FormDisplayerContainer.js.map