import React, { useCallback, useEffect, useImperativeHandle, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { BallBeat } from "react-pure-loaders";
import { FormOpenedState } from "../../../api";
import ReactFormRenderer from "../ReactFormRenderer/ReactFormRenderer";
import HtmlFormRenderer from "../HtmlFormRenderer/HtmlFormRenderer";
import "../styles.css";
import { InternalFormDisplayerApiImpl } from "./apis";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const FormDisplayer = React.forwardRef(({ isEnvelopeConnectedToChannel, content, data, context, onOpenForm, ouiaId, ouiaSafe }, forwardedRef) => {
    const [source, setSource] = useState();
    const [resources, setResources] = useState();
    const [formData, setFormData] = useState();
    const [formApi, setFormApi] = useState({});
    const [isExecuting, setIsExecuting] = useState(false);
    const doOpenForm = (config) => {
        const api = {};
        setFormApi(new InternalFormDisplayerApiImpl(api, config.onOpen));
        return api;
    };
    const canDisplayForm = useCallback(() => {
        return isEnvelopeConnectedToChannel && !isExecuting && source;
    }, [isEnvelopeConnectedToChannel, isExecuting, source]);
    useEffect(() => {
        window.Form = {
            openForm: doOpenForm,
        };
    }, []);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setSource(content.source);
            setResources(content.configuration.resources);
            setFormData(data);
        }
    }, [isEnvelopeConnectedToChannel, content, data]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel && formApi) {
            formApi.onOpen({
                data: formData,
                context: context,
            });
            setTimeout(() => {
                onOpenForm({
                    state: FormOpenedState.OPENED,
                    size: {
                        height: document.body.scrollHeight,
                        width: document.body.scrollWidth,
                    },
                });
            }, 500);
        }
    }, [formApi]);
    useImperativeHandle(forwardedRef, () => formApi, [formApi]);
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "form-displayer", ouiaSafe)), canDisplayForm() ? (React.createElement("div", { id: "inner-form-container" }, content.formInfo && content.formInfo.type === "TSX" ? (React.createElement(ReactFormRenderer, { source: source, resources: resources, setIsExecuting: setIsExecuting })) : (React.createElement(HtmlFormRenderer, { source: source, resources: resources })))) : (React.createElement(Bullseye, { className: "kogito-form-displayer__ball-beats" },
        React.createElement(BallBeat, { color: "#000000", loading: !isEnvelopeConnectedToChannel })))));
});
export default FormDisplayer;
//# sourceMappingURL=FormDisplayer.js.map