import React from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Gallery, GalleryItem } from "@patternfly/react-core/dist/js/layouts/Gallery";
import FormCard from "../FormCard/FormCard";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
const FormsGallery = ({ driver, formsData, isLoading, ouiaId, ouiaSafe }) => {
    if (isLoading) {
        return (React.createElement(Bullseye, null,
            React.createElement(KogitoSpinner, { spinnerText: "Loading forms...", ouiaId: "forms-list-loading-forms" })));
    }
    if (!isLoading && formsData && formsData.length === 0) {
        return (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }));
    }
    return (React.createElement(Gallery, Object.assign({ hasGutter: true, style: { margin: "25px" } }, componentOuiaProps(ouiaId, "forms-gallery", ouiaSafe)), formsData &&
        formsData.map((formData, index) => (React.createElement(GalleryItem, { key: index },
            React.createElement(FormCard, { formData: formData, key: index, driver: driver }))))));
};
export default FormsGallery;
//# sourceMappingURL=FormsGallery.js.map