import React, { useState } from "react";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Toolbar, ToolbarContent, ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { FilterIcon, SyncIcon } from "@patternfly/react-icons/dist/js/icons";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
var Category;
(function (Category) {
    Category["FORM_NAME"] = "Form name";
})(Category || (Category = {}));
const FormsListToolbar = ({ applyFilter, filterFormNames, setFilterFormNames, ouiaSafe, ouiaId, }) => {
    const [formNameInput, setFormNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter({
            formNames: [],
        });
        setFilterFormNames([]);
    };
    const doRefresh = () => {
        applyFilter({
            formNames: [...filterFormNames],
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            formNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newFilterFormNames = [...filterFormNames];
        if (categoryName === Category.FORM_NAME) {
            _.remove(newFilterFormNames, (status) => {
                return status === value;
            });
            setFilterFormNames(newFilterFormNames);
            applyFilter({
                formNames: newFilterFormNames,
            });
        }
    };
    const doApplyFilter = () => {
        const newFormNames = [...filterFormNames];
        if (formNameInput && !newFormNames.includes(formNameInput)) {
            newFormNames.push(formNameInput);
            setFilterFormNames(newFormNames);
        }
        setFormNameInput("");
        applyFilter({
            formNames: newFormNames,
        });
    };
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarFilter, { key: "input-form-name", chips: filterFormNames, deleteChip: onDeleteFilterGroup, categoryName: Category.FORM_NAME },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "formName", id: "formName", type: "search", "aria-label": "form name", onChange: setFormNameInput, onKeyPress: onEnterClicked, placeholder: "Filter by Form name", value: formNameInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter }, "Apply Filter")))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: doRefresh, id: "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(Toolbar, Object.assign({ id: "forms-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "forms-list-toolbar", ouiaSafe)),
        React.createElement(ToolbarContent, null, toolbarItems)));
};
export default FormsListToolbar;
//# sourceMappingURL=FormsListToolbar.js.map