import { EditorLanguageServiceArgs, ELsNode, IEditorLanguageService } from "@kie-tools/json-yaml-language-service/dist/channel";
import { SwfServiceCatalogFunction, SwfServiceCatalogService } from "@kie-tools/serverless-workflow-service-catalog/dist/api";
import { JSONSchema } from "vscode-json-languageservice";
import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, CompletionItem, Diagnostic, Position, Range } from "vscode-languageserver-types";
import { CodeCompletionStrategy } from "./types";
export declare type SwfLanguageServiceConfig = {
    shouldConfigureServiceRegistries: () => boolean;
    shouldServiceRegistriesLogIn: () => boolean;
    canRefreshServices: () => boolean;
    getSpecsDirPosixPaths: (textDocument: TextDocument) => Promise<{
        specsDirRelativePosixPath: string;
        specsDirAbsolutePosixPath: string;
    }>;
    getRoutesDirPosixPaths: (textDocument: TextDocument) => Promise<{
        routesDirRelativePosixPath: string;
        routesDirAbsolutePosixPath: string;
    }>;
    shouldDisplayServiceRegistriesIntegration: () => Promise<boolean>;
    shouldReferenceServiceRegistryFunctionsWithUrls: () => Promise<boolean>;
    shouldIncludeJsonSchemaDiagnostics: () => Promise<boolean>;
};
export declare type SwfLanguageServiceArgs = EditorLanguageServiceArgs & {
    serviceCatalog: {
        global: {
            getServices: () => Promise<SwfServiceCatalogService[]>;
        };
        relative: {
            getServices: (textDocument: TextDocument) => Promise<SwfServiceCatalogService[]>;
        };
        getServiceFileNameFromSwfServiceCatalogServiceId: (registryName: string, swfServiceCatalogServiceId: string) => Promise<string>;
    };
    jqCompletions: {
        remote: {
            getJqAutocompleteProperties: (args: {
                textDocument: TextDocument;
                schemaPaths: string[];
            }) => Promise<Record<string, string>[]>;
        };
        relative: {
            getJqAutocompleteProperties: (args: {
                textDocument: TextDocument;
                schemaPaths: string[];
            }) => Promise<Record<string, string>[]>;
        };
    };
    config: SwfLanguageServiceConfig;
};
export declare function isVirtualRegistry(serviceCatalogFunction: SwfServiceCatalogFunction): boolean;
export declare class SwfLanguageService implements IEditorLanguageService {
    private readonly args;
    private readonly els;
    constructor(args: SwfLanguageServiceArgs);
    getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: CodeCompletionStrategy;
    }): Promise<CompletionItem[]>;
    getCodeLenses(args: {
        content: string;
        uri: string;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: CodeCompletionStrategy;
    }): Promise<CodeLens[]>;
    private getFunctionDiagnostics;
    private generateDiagnostic;
    private getWarningMessage;
    getDiagnostics(args: {
        content: string;
        uriPath: string;
        rootNode: ELsNode | undefined;
        getSchemaDiagnostics: (args: {
            textDocument: TextDocument;
            fileMatch: string[];
        }) => Promise<Diagnostic[]>;
    }): Promise<Diagnostic[]>;
    getSchemaDiagnostics(args: {
        textDocument: TextDocument;
        fileMatch: string[];
        jsonSchema: JSONSchema;
    }): Promise<Diagnostic[]>;
    dispose(): void;
    private createSwfCompletionItemServiceCatalogProperty;
    private getSwfCompletionItemServiceCatalogFunctionOperation;
    private getSwfCompletionItemServiceCatalogEventReference;
}
//# sourceMappingURL=SwfLanguageService.d.ts.map