"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwfLanguageService = exports.isVirtualRegistry = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
var api_1 = require("@kie-tools/serverless-workflow-service-catalog/dist/api");
var path_browserify_1 = require("path-browserify");
var vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var SwfLanguageServiceCodeCompletion_1 = require("./SwfLanguageServiceCodeCompletion");
var SwfLanguageServiceCodeLenses_1 = require("./SwfLanguageServiceCodeLenses");
var swfRefValidationMap_1 = require("./swfRefValidationMap");
function isVirtualRegistry(serviceCatalogFunction) {
    return (serviceCatalogFunction.source.type === "SERVICE_REGISTRY" && serviceCatalogFunction.source.registry === "Virtual");
}
exports.isVirtualRegistry = isVirtualRegistry;
var SwfLanguageService = (function () {
    function SwfLanguageService(args) {
        this.args = args;
        this.els = new channel_1.EditorLanguageService(this.args);
    }
    SwfLanguageService.prototype.getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var doc, swfCompletionItemServiceCatalogServices, _a, _b, _c, _d;
            var _this = this;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        doc = vscode_languageserver_textdocument_1.TextDocument.create(args.uri, this.args.lang.fileLanguage, 0, args.content);
                        _b = (_a = Promise).all;
                        _c = [[]];
                        return [4, this.args.serviceCatalog.global.getServices()];
                    case 1:
                        _d = [__spreadArray.apply(void 0, _c.concat([__read.apply(void 0, [(_e.sent())]), false]))];
                        return [4, this.args.serviceCatalog.relative.getServices(doc)];
                    case 2: return [4, _b.apply(_a, [__spreadArray.apply(void 0, _d.concat([__read.apply(void 0, [(_e.sent())]), false])).map(function (service) { return __awaiter(_this, void 0, void 0, function () {
                                var _a;
                                var _b;
                                var _this = this;
                                var _c, _d;
                                return __generator(this, function (_e) {
                                    switch (_e.label) {
                                        case 0:
                                            _a = [__assign({}, service)];
                                            _b = {};
                                            return [4, Promise.all(service.functions.map(function (func) { return __awaiter(_this, void 0, void 0, function () {
                                                    var _a;
                                                    var _b;
                                                    return __generator(this, function (_c) {
                                                        switch (_c.label) {
                                                            case 0:
                                                                _a = [__assign({}, func)];
                                                                _b = {};
                                                                return [4, this.getSwfCompletionItemServiceCatalogFunctionOperation(service, func, doc)];
                                                            case 1: return [2, (__assign.apply(void 0, _a.concat([(_b.operation = _c.sent(), _b)])))];
                                                        }
                                                    });
                                                }); }))];
                                        case 1:
                                            _b.functions = _e.sent();
                                            return [4, Promise.all((_d = (_c = service.events) === null || _c === void 0 ? void 0 : _c.map(function (event) { return __awaiter(_this, void 0, void 0, function () {
                                                    var _a;
                                                    var _b, _c;
                                                    return __generator(this, function (_d) {
                                                        switch (_d.label) {
                                                            case 0:
                                                                _a = [__assign({}, event)];
                                                                _b = {};
                                                                _c = {};
                                                                return [4, this.getSwfCompletionItemServiceCatalogEventReference(service, event, doc)];
                                                            case 1: return [2, (__assign.apply(void 0, _a.concat([(_b.metadata = (_c.reference = _d.sent(),
                                                                        _c), _b)])))];
                                                        }
                                                    });
                                                }); })) !== null && _d !== void 0 ? _d : [])];
                                        case 2: return [2, (__assign.apply(void 0, _a.concat([(_b.events = _e.sent(), _b)])))];
                                    }
                                });
                            }); })])];
                    case 3:
                        swfCompletionItemServiceCatalogServices = _e.sent();
                        return [2, this.els.getCompletionItems(__assign(__assign({}, args), { completions: completions, extraCompletionFunctionsArgs: {
                                    langServiceConfig: this.args.config,
                                    swfCompletionItemServiceCatalogServices: swfCompletionItemServiceCatalogServices,
                                    jqCompletions: this.args.jqCompletions,
                                } }))];
                }
            });
        });
    };
    SwfLanguageService.prototype.getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var displayRhhccIntegration;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.config.shouldDisplayServiceRegistriesIntegration()];
                    case 1:
                        displayRhhccIntegration = _a.sent();
                        return [2, this.els.getCodeLenses(__assign(__assign({}, args), { codeLenses: SwfLanguageServiceCodeLenses_1.SwfLanguageServiceCodeLenses, extraCodeLensesFunctionsArgs: {
                                    config: this.args.config,
                                    displayRhhccIntegration: displayRhhccIntegration,
                                } }))];
                }
            });
        });
    };
    SwfLanguageService.prototype.getFunctionDiagnostics = function (services) {
        var _this = this;
        return services.flatMap(function (value) { return _this.generateDiagnostic(value.functions); });
    };
    SwfLanguageService.prototype.generateDiagnostic = function (serviceCatalogFunctions) {
        var functionsWithoutName = serviceCatalogFunctions.filter(function (fs) { return !fs.name && !isVirtualRegistry(fs); });
        return functionsWithoutName.length >= 1
            ? [
                vscode_languageserver_types_1.Diagnostic.create(vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(0, 0), vscode_languageserver_types_1.Position.create(0, 0)), this.getWarningMessage(serviceCatalogFunctions[0].source), vscode_languageserver_types_1.DiagnosticSeverity.Warning),
            ]
            : [];
    };
    SwfLanguageService.prototype.getWarningMessage = function (swfServiceCatalogFunctionSource) {
        if (swfServiceCatalogFunctionSource.type == "SERVICE_REGISTRY") {
            return "The ".concat(swfServiceCatalogFunctionSource.serviceId, " service in the  ").concat(swfServiceCatalogFunctionSource.registry, " registry is missing the \"operationId\" property in at least one operation");
        }
        if (swfServiceCatalogFunctionSource.type === "LOCAL_FS") {
            return "The ".concat(swfServiceCatalogFunctionSource.serviceFileAbsolutePath, " service is missing the \"operationId\" property in at least one operation");
        }
        return "";
    };
    SwfLanguageService.prototype.getDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, _c;
            var _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        _b = (_a = this.els).getDiagnostics;
                        _c = [__assign({}, args)];
                        _d = { validationMap: swfRefValidationMap_1.swfRefValidationMap };
                        return [4, this.args.config.shouldIncludeJsonSchemaDiagnostics()];
                    case 1: return [4, _b.apply(_a, [__assign.apply(void 0, _c.concat([(_d.getSchemaDiagnostics = (_e.sent())
                                    ? args.getSchemaDiagnostics
                                    : undefined, _d)]))])];
                    case 2: return [2, _e.sent()];
                }
            });
        });
    };
    SwfLanguageService.prototype.getSchemaDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.els.getSchemaDiagnostics(args)];
            });
        });
    };
    SwfLanguageService.prototype.dispose = function () {
        this.els.dispose();
    };
    SwfLanguageService.prototype.createSwfCompletionItemServiceCatalogProperty = function (containingService, item, dirRelativePosixPath) {
        return __awaiter(this, void 0, void 0, function () {
            var serviceFileName, serviceFileRelativePosixPath, serviceFileName, serviceFileRelativePosixPath;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(item.source.type === api_1.SwfCatalogSourceType.LOCAL_FS)) return [3, 1];
                        serviceFileName = path_browserify_1.posix.basename(item.source.serviceFileAbsolutePath);
                        serviceFileRelativePosixPath = path_browserify_1.posix.join(dirRelativePosixPath, serviceFileName);
                        return [2, "".concat(serviceFileRelativePosixPath, "#").concat(item.name)];
                    case 1: return [4, this.args.config.shouldReferenceServiceRegistryFunctionsWithUrls()];
                    case 2:
                        if (!((_a.sent()) &&
                            containingService.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY &&
                            item.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY)) return [3, 3];
                        return [2, "".concat(containingService.source.url, "#").concat(item.name)];
                    case 3:
                        if (!(containingService.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY &&
                            item.source.type === api_1.SwfCatalogSourceType.SERVICE_REGISTRY)) return [3, 5];
                        return [4, this.args.serviceCatalog.getServiceFileNameFromSwfServiceCatalogServiceId(containingService.source.registry, containingService.source.id)];
                    case 4:
                        serviceFileName = _a.sent();
                        serviceFileRelativePosixPath = path_browserify_1.posix.join(dirRelativePosixPath, serviceFileName);
                        return [2, "".concat(serviceFileRelativePosixPath, "#").concat(item.name)];
                    case 5: throw new Error("Unknown Service Catalog source type");
                }
            });
        });
    };
    SwfLanguageService.prototype.getSwfCompletionItemServiceCatalogFunctionOperation = function (containingService, func, document) {
        return __awaiter(this, void 0, void 0, function () {
            var specsDirRelativePosixPath, routesDirRelativePosixPath, dirRelativePosixPath;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.config.getSpecsDirPosixPaths(document)];
                    case 1:
                        specsDirRelativePosixPath = (_a.sent()).specsDirRelativePosixPath;
                        return [4, this.args.config.getRoutesDirPosixPaths(document)];
                    case 2:
                        routesDirRelativePosixPath = (_a.sent()).routesDirRelativePosixPath;
                        if (containingService.type === api_1.SwfServiceCatalogServiceType.camelroute) {
                            dirRelativePosixPath = routesDirRelativePosixPath;
                        }
                        else {
                            dirRelativePosixPath = specsDirRelativePosixPath;
                        }
                        return [2, this.createSwfCompletionItemServiceCatalogProperty(containingService, func, dirRelativePosixPath)];
                }
            });
        });
    };
    SwfLanguageService.prototype.getSwfCompletionItemServiceCatalogEventReference = function (containingService, event, document) {
        return __awaiter(this, void 0, void 0, function () {
            var specsDirRelativePosixPath, dirRelativePosixPath;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.config.getSpecsDirPosixPaths(document)];
                    case 1:
                        specsDirRelativePosixPath = (_a.sent()).specsDirRelativePosixPath;
                        dirRelativePosixPath = specsDirRelativePosixPath;
                        return [2, this.createSwfCompletionItemServiceCatalogProperty(containingService, event, dirRelativePosixPath)];
                }
            });
        });
    };
    return SwfLanguageService;
}());
exports.SwfLanguageService = SwfLanguageService;
var completions = new Map([
    [null, SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getEmptyFileCodeCompletions],
    [["start"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getStartCompletions],
    [["functions", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getFunctionCompletions],
    [["functions", "*", "operation"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getFunctionOperationCompletions],
    [["events", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getEventsCompletions],
    [["states", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getStatesCompletions],
    [["states", "*", "actions", "*", "functionRef"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getFunctionRefCompletions],
    [
        ["states", "*", "actions", "*", "functionRef", "refName"],
        SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getFunctionRefRefnameCompletions,
    ],
    [
        ["states", "*", "actions", "*", "functionRef", "arguments"],
        SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getFunctionRefArgumentsCompletions,
    ],
    [["states", "*", "actions", "*", "functionRef", "arguments", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "actions", "*", "actionDataFilter", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "stateDataFilter", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "onEvents", "*", "eventDataFilter", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "eventDataFilter", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "dataConditions", "*", "condition"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getJqcompletions],
    [["states", "*", "onEvents", "*", "eventRefs", "*"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getEventRefsCompletions],
    [["states", "*", "transition"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getTransitionCompletions],
    [["states", "*", "dataConditions", "*", "transition"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getTransitionCompletions],
    [["states", "*", "defaultCondition", "transition"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getTransitionCompletions],
    [["states", "*", "eventConditions", "*", "transition"], SwfLanguageServiceCodeCompletion_1.SwfLanguageServiceCodeCompletion.getTransitionCompletions],
]);
//# sourceMappingURL=SwfLanguageService.js.map