import React from "react";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { BulkList } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const JobsCancelModal = ({ actionType, modalContent, modalTitle, isModalOpen, handleModalToggle, jobOperations, ouiaId, ouiaSafe, }) => {
    return (React.createElement(Modal, Object.assign({ variant: "small", title: "", header: modalTitle, isOpen: isModalOpen, onClose: handleModalToggle, "aria-label": `${actionType} Modal`, "aria-labelledby": `${actionType} Modal`, actions: [
            React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: handleModalToggle }, "OK"),
        ] }, componentOuiaProps(ouiaId, "jobs-cancel-modal", ouiaSafe)), modalContent.length > 0 ? (React.createElement(TextContent, null,
        React.createElement(Text, null, modalContent))) : (React.createElement(BulkList, { operationResult: jobOperations }))));
};
//# sourceMappingURL=JobsCancelModal.js.map